/**
 * Copyright (c) 2015 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "string"
#include "XBeeLib.h"
#include "C12832_lcd.h"

using namespace XBeeLib;

#define END_NODE      ((uint16_t)0x0)
const char *field_delimiter=";";
const char *controller_name="Toilet_Control";
const char *procCommand_ON="ON";
const char *procCommand_OFF="OFF";
XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);
DigitalOut led[]={(LED1),(LED2),(LED3)};
DigitalOut fan(p13);
char send_data [98];
C12832_LCD lcd;

const RemoteXBee802 remoteDevice16b = RemoteXBee802(END_NODE);

void clear_send_data() {
    for (int i=0;i<98;i++) send_data[i]=0;
}

int calculate_send_data_size() {
    for (int i=0;i<98;i++) if (send_data[i]==0) return i;
    return 98;
}

const char fan_status_format []="2;Toilet_Control;ToiletWater;%s";
void send_fan_status (const RemoteXBee802& remote, const char* value) {
    snprintf(send_data,98,fan_status_format,value);
    
    xbee.send_data(remote,(const uint8_t *)send_data,calculate_send_data_size());
    clear_send_data();
}

static void receive_cb(const RemoteXBee802& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{   
    led[1]=1;
    char* read_data = new char [len];
    for (int i = 0; i < len; i++)
        read_data[i]=data[i];
    lcd.cls();
    lcd.printf("%s",read_data);
    
    string tempCmd (strtok(read_data,field_delimiter));
    string commandId = tempCmd.substr(tempCmd.length()-1,tempCmd.length());
    string ctrl (strtok(NULL,field_delimiter));
    string act (strtok(NULL,field_delimiter));
    string status (strtok(NULL,field_delimiter));
         
    if (!ctrl.find(controller_name)) {
        if (!commandId.compare("1")) {
            if (!act.compare("ToiletWater")) {
                int statusInt=(status.find(procCommand_ON) != std::string::npos);
                fan=statusInt;
                led[2]=statusInt;
                        
                if (statusInt) send_fan_status(remote,procCommand_ON);
                else send_fan_status(remote,procCommand_OFF);
            }
        }
    }
    
    led[1]=0;
}

int main()
{
    send_fan_status(remoteDevice16b,"ON");
    xbee.register_receive_cb(&receive_cb);

    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);
    
    led[0]=1;
    lcd.printf("Ready");
    
    fan=1;
    led[2]=1;
    while (true) {
        xbee.process_rx_frames();
        wait_ms(100);
    }
}
