#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include <string>
#include "WiflyInterface.h"
#include "rtos.h"
#include "LM75B.h"

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;

WiflyInterface wifly(p9, p10, p30, p29, "SSID", "PASSWORD", WPA);
AnalogIn ain(p17);
C12832_LCD lcd;
DigitalOut led [] ={(LED1),(LED2),(LED3),(LED4)};
LM75B tempSensor(p28,p27);
const char *server_ip="192.168.10.2";
const int server_port=40000;
char status_data[100];

const char* tempFormat="0;TechRoomB_Monitor;BlockB_Temperature;%f";
void sendTempReading () {
    led[2]=1;
    TCPSocketConnection conn;
    
    for (int i=0;i<100;i++) status_data[i]=0;
    snprintf(status_data,100,tempFormat,(((float)tempSensor)+55)/175);

    led[3]=1;
    if (conn.connect(server_ip,server_port)==0 && conn.send_all(status_data,100)>=0); wdt.kick();
    led[3]=0;
    
    wait(0.1);
    conn.close();
    led[2]=0;
}

const char* currentFormat="0;TechRoomB_Monitor;BlockB_AirCondCurrent;%f";
void sendCurrentReading () {
    led[0]=1;
    TCPSocketConnection conn;
    
    float max=0.0;
    time_t start=time(NULL);
    while (time(NULL)-start<2) {
        if (ain>0 && ain<0.3 && ain>max) max=ain;
    }
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Current : %f",max);
        
    for (int i=0;i<100;i++) status_data[i]=0;
    snprintf(status_data,100,currentFormat,max*3);
    
    led[1]=1;
    if (conn.connect(server_ip,server_port)==0 && conn.send_all(status_data,100)>=0); wdt.kick();
    led[1]=0;
    
    wait(0.1);
    conn.close();
    led[0]=0;
}

void sendReading() {
    sendCurrentReading();
    wait(3.0);
    sendTempReading();
}

void setupWifly() {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Start WiFi Setup\n");
    
    wifly.init();
}

void checkWiflyConnection() {
    if (!wifly.is_associated()) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Reconnecting...");
        while (!wifly.connect());
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("IP Address : %s\n", wifly.getIPAddress());
    }
}

void getCommand() {
    checkWiflyConnection();
    wdt.kick(120.0);
    while (1) {
        sendReading();
        wait(60.0);
    }
}

int main() {
    set_time(0);
    mbed_interface_disconnect(); //Disable debugging to improve ADC precision. | Comment this if you need debugging via serial.

    setupWifly();

    getCommand();
}