#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include <string>
#include "WiflyInterface.h"
#include "rtos.h"

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
WiflyInterface wifly(p9, p10, p30, p29, "SSID", "PASSWORD", WPA);
AnalogIn ain(p17);
C12832_LCD lcd;
DigitalOut fan(p13);
DigitalOut led [] ={(LED1),(LED2)};
const char *server_ip="192.168.10.2";
const int server_port=40000;
const char *field_delimiter=";";
const char *controller_name="TechRoomB_Control";
const char *procCommand_ON="ON";
const char *procCommand_OFF="OFF";
char read_data[100];
char send_data[100];
char status_data[50];


void sendActuatorStatusFunc () {
    TCPSocketConnection conn;
         
    for (int i=0;i<100;i++) status_data[i]=0;
    
    if (fan==1) snprintf(status_data,50,"2;%s;AirCond;ON",controller_name);
    else snprintf(status_data,50,"2;%s;AirCond;OFF",controller_name);
    
    if (conn.connect(server_ip,server_port)==0) conn.send_all(status_data,50);
    
    wait(0.1);
    conn.close();
}

void setupWifly() {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Start WiFi Setup\n");
    
    wifly.init();
}

void checkWiflyConnection() {
    if (!wifly.is_associated()) {
        while (!wifly.connect()) 
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("IP Address : %s\n", wifly.getIPAddress());
        
        sendActuatorStatusFunc();
    }
}


void processCommand (TCPSocketServer tserver) {
        TCPSocketConnection conn;
        
        if (tserver.accept(conn)==0) {
            int result=conn.receive_all(read_data,100);
                
            string tempCmd (strtok(read_data,field_delimiter));
            string commandId = tempCmd.substr(tempCmd.length()-1,tempCmd.length());
            string ctrl (strtok(NULL,field_delimiter));
            string act (strtok(NULL,field_delimiter));
            string status (strtok(NULL,field_delimiter));
                    
            if (!ctrl.find(controller_name)) {
                if (!commandId.compare("1")) {
                    if (!act.compare("AirCond")) {
                        int statusInt=status.compare(procCommand_OFF);
                        fan=statusInt;
                        led[1]=statusInt;
                        
                        for (int i=0;i<100;i++) send_data[i]=0;
                        strcpy(send_data,status.c_str());
                        
                        conn.send_all(send_data,100);
                        wait(0.1); // No idea why. : https://developer.mbed.org/forum/mbed/topic/3812/
                    }
                }
            }
            
            conn.close();
        }
}

void getCommand() {
    checkWiflyConnection();
    while (1) {
        TCPSocketServer tserver;
        tserver.bind(40002);
        tserver.listen();
        
        led[0]=1;
        processCommand(tserver);
        tserver.close();
        led[0]=0;
    }
}

int main() {
    set_time(0);
    mbed_interface_disconnect(); //Disable debugging to improve ADC precision. | Comment this if you need debugging via serial.
    fan=1;
    led[1]=1;
    setupWifly();

    getCommand();
}