/*******************************************************************************
Jacob Kang, Montassar Mouaffak
ES305
Section 2141
This will drive a DC motor with a sinusoidal duty cycle for a user specified
amount of time and measure the speed of the motor shaft. Then it will send the
elapsed time, speed, and duty cycle at each time increment across the serial
port.
*******************************************************************************/

//declare libraries

#include "mbed.h"
#include "mbedWSEsbc.h"
#define PI (3.14159)

//declare objects

Ticker Controller;


//declare variables

float time_tot;
float current_time;
float ctrl_period = 0.0083;
float datastrm = 0.01;
float dutcyc;
float DCAmp;
float speed;
float meas;
float rad_curr;
float rad_old = 0.0;

// declare functions

void ctrCode();
void stepCode();

//Enter main function
int main()
{

    //initialize board
    mbedWSEsbcInit(115200);
    //initialize pwm
    mot_en1.period(.020);

    while(1) {
        pc.scanf("%f,%f", &time_tot,&DCAmp);
        current_time = 0.0;
        t.reset(); //reset time object
        Controller.attach(&stepCode,ctrl_period);
        t.start();
        while(current_time <= time_tot) {
            pc.printf("%f,%f,%f\n",current_time,speed,dutcyc);
            wait(datastrm);
        }
        Controller.detach(); // detach ticker to turn off controller
        mot_control(1,0.0);
    }
}


void ctrCode()
{
    //Read current elasped time
    current_time = t.read();
    //Read encoder
    meas = LS7366_read_counter(1);
    //Convert from counts to radians
    rad_curr = (meas/6500)*2*PI;
    //Estimate speed
    speed = (rad_curr - rad_old)/ctrl_period;
    //Age variables
    rad_old = rad_curr;
    //compute duty cycle for motor (if necessary)
    dutcyc = DCAmp*sin((2.0*PI*current_time)/5.0);
    //send duty cycle to motor
    mot_control(1,dutcyc);
}

void stepCode()
{
    //Read current elasped time
    current_time = t.read();
    //Read encoder
    meas = LS7366_read_counter(1);
    //Convert from counts to radians
    rad_curr = (meas/6500)*2*PI;
    //Estimate speed
    speed = (rad_curr - rad_old)/ctrl_period;
    //Age variables
    rad_old = rad_curr;
    //compute duty cycle for motor (if necessary)
    if(current_time <0.1) {
        dutcyc = 0.0;
    } else {
        dutcyc = DCAmp;
    }
    dutcyc = DCAmp*sin((2.0*PI*current_time)/5.0);
    //send duty cycle to motor
    mot_control(1,dutcyc);
}
