#include "MicroBit.h"

MicroBit uBit;

void onButtonA(MicroBitEvent e) {
    MicroBitImage heart("0, 1, 0, 1, 0\n1, 1, 1, 1, 1\n1, 1, 1, 1, 1\n0, 1, 1, 1, 0\n0, 0, 1, 0, 0\n");
    uBit.display.setDisplayMode(DISPLAY_MODE_BLACK_AND_WHITE_LIGHT_SENSE);
    for (int y = 4; y >= 0; --y) {
      uBit.display.image.paste(heart, 0, y);
      uBit.sleep(500);
    }
}

void onButtonB(MicroBitEvent e) {
    uBit.display.print("FOX");
}

int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();

    // Insert your code here!
    
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButtonA);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onButtonB);

    // If main exits, there may still be other fibers running or registered event handlers etc.
    // Simply release this fiber, which will mean we enter the scheduler. Worse case, we then
    // sit in the idle task forever, in a power efficient sleep.
    release_fiber();
}

