#include "MicroBit.h"

MicroBit uBit;
MicroBitSerial serial(USBTX, USBRX);
MicroBitI2C i2c(I2C_SDA0, I2C_SCL0); 

MicroBitAccelerometer accelerometer(i2c); 

MicroBitStorage storage; 

MicroBitCompass compass(i2c, accelerometer, storage); 

int main()
{
    uBit.init();

    while (1) {
      int heading = compass.heading();
      serial.send((ManagedString)heading);
      uBit.sleep(500);
    }
    
    release_fiber();
}

