/*
 *  PCF2129 library
 *
 */

#include    "mbed.h"
#include    "PCF2129.h"
#define PCF2129_ADDRESS   0xA2

PCF2129::PCF2129( PinName sda, PinName scl ) : m_i2c( sda, scl)
{
    init( 0, 0, 0, 0x07 );      // int disable,CLKout diable
}

PCF2129::~PCF2129()
{
//    if ( NULL != m_i2c )
//        delete  m_i2c;
}

int PCF2129::init( char vControl_1, char vControl_2, char vControl_3, char vCLKOUT_ctl )
{
    char    data[ 4 ];
    int     err;

    data[ 0 ]   = 0;            // Control_1; //  access start register address
    data[ 1 ]   = vControl_1;
    data[ 2 ]   = vControl_2;
    data[ 3 ]   = vControl_3;

    err     = m_i2c.write( PCF2129_ADDRESS , data, sizeof( data ) );
    err    |= set_register( 0x0F, vCLKOUT_ctl );    // ClockOut Control

    return ( err ? I2C_ACCESS_FAIL : NO_ERROR );
}

int PCF2129::is_init_required( void )
{
    return ( read_register( 0x03 ) & 0x80 ? true : false );
}

int PCF2129::set_time( struct tm *dtp ){
    char        buf[ 8 ];
    char        err;

    buf[ 0 ]    = 0x03;             // Seconds;
    buf[ 1 ]    = Dec2RtcData( dtp->tm_sec  );
    buf[ 2 ]    = Dec2RtcData( dtp->tm_min  );
    buf[ 3 ]    = Dec2RtcData( dtp->tm_hour );
    buf[ 4 ]    = Dec2RtcData( dtp->tm_mday );
    buf[ 5 ]    = Dec2RtcData( dtp->tm_wday );
    buf[ 6 ]    = Dec2RtcData( dtp->tm_mon  + 1   );
    buf[ 7 ]    = Dec2RtcData( dtp->tm_year - 100 );

    err = m_i2c.write( PCF2129_ADDRESS, buf, 8 );

    return ( err ? I2C_ACCESS_FAIL : NO_ERROR );
}

int PCF2129::set_time( time_t *tp ){
    return ( set_time( localtime( tp ) ) );
}

time_t PCF2129::get_time( time_t *tp ){
    struct tm   dt, *dtp;
    time_t      t;
    char        buf[ 8 ];

    dtp = &dt;

    buf[ 0 ]    = 0x03;         //Seconds;  //  read start register address

    if ( m_i2c.write( PCF2129_ADDRESS, buf, 1 ) )
        return ( TIME_FUNC_ERROR );

    if ( m_i2c.read( PCF2129_ADDRESS, buf, 7 ) )
        return ( TIME_FUNC_ERROR );

    dtp->tm_sec     = RtcData2Dec( buf[ 0 ] );
    dtp->tm_min     = RtcData2Dec( buf[ 1 ] );
    dtp->tm_hour    = RtcData2Dec( buf[ 2 ] );
    dtp->tm_mday    = RtcData2Dec( buf[ 3 ] );
    dtp->tm_wday    = RtcData2Dec( buf[ 4 ] );
    dtp->tm_mon     = RtcData2Dec( buf[ 5 ] ) - 1;
    dtp->tm_year    = RtcData2Dec( buf[ 6 ] ) + 100;

    t   = mktime( dtp );

    if ( tp )
        *tp  = t;

    return( t );
}

char PCF2129::Dec2RtcData(char tmp){
    return ((tmp/10)<<4) | ((tmp%10)&0x0F);
}

char PCF2129::RtcData2Dec(char tmp){
    return (tmp&0x0F) + (tmp>>4)*10;
}

int PCF2129::set_register( char reg_addr, char reg_data )
{
    char    b[ 2 ];

    b[ 0 ]    = reg_addr;
    b[ 1 ]    = reg_data;

    return ( m_i2c.write( PCF2129_ADDRESS, b, sizeof( b ) ) );
}

int PCF2129::read_register( char reg_addr )
{
    char    data;

    data    = reg_addr;
    m_i2c.write( PCF2129_ADDRESS, &data, 1 );
    m_i2c.read( PCF2129_ADDRESS, &data, 1 );

    return ( data );
}

