/* mbed library for LM60
 * king33jp
 * LM60 : http://www.tij.co.jp/product/jp/lm60
 *      Res    = 6.25mV/C
 *      Offset = 424mV
 *      Vo = ( 0.00625 x T ) + 0.424
 *      T  = ( Vo - 0.424 ) / 0.00625
 *         = ( Vo - 0.424 ) * 160
 */
#ifndef LM60_2015
#define LM60_2015

#include "mbed.h"

/** Get temperature from LM60 class
 *
 * Example:
 * @code
 * #include "LM60.h"
 * #include "mbed.h"
 * 
 * LM60 lm60(PTB0, 3.3f);
 * 
 * int main() {
 *     float temp;
 *     
 *     while(1) {
 *         temp = lm60.GetTemp();
 *         wait(1);
 *     }
 * }
 * @endcode
 */
class LM60{

public:
    /** A constructor of LM60 class
     * @param lm60 pin connected to vout of LM60
     * @param vcc Vcc voltage ( or AREF voltage)
     */
    LM60(PinName lm60 , float vcc );
    
    /** Get temperature from LM60
     * @return temperature from LM60 in degree
     */
    float GetTemp();

private:
    AnalogIn _lm60;
    float _vcc;
};
#endif
