#include "mbed.h"
#include "S6D0151_TFT.h"
#include "Consolas12.h"
#include "Prototype24x34_T.h"

S6D0151_TFT TFT(PTD2, NC, PTD1, PTD6, PTD7,"TFT"); // mosi, miso, sclk, cs, reset

DigitalOut myled(LED2);
Serial tocos(PTE0,PTE1);
//Serial pc(USBTX,USBRX);

PwmOut bkl(PTD4);

int main() {
    char recv_str[64];
    char ad1_str[5]={'\0'};
    char ad1h_str[5]={'\0'};
    char tmp_str[10]={'\0'};
    char v_id_str[10]={'\0'};
    char v_lg_str[10]={'\0'};
    
    int ad1,ad1h,v_lqi,v_bat;
    int lm61;
    char child1[]="810CD3F0";
    int vpos_offset;

    tocos.baud(115200);
    bkl.period_ms(1);
    bkl = 1;    // 

//    TFT.claim(stdout);          // send stdout to the TFT display 
    TFT.set_orientation(2);

    TFT.background(Black);      // set background to black
    TFT.foreground(White);
    TFT.cls();
    TFT.set_font((unsigned char *) Consolas9x16 );
    TFT.locate( 0, 0); TFT.printf("ZigBee Temp");

    TFT.set_font( (unsigned char *) Prototype24x34 );
    TFT.locate( 63, 18+0 );    TFT.printf(".");
    TFT.locate( 63, 18+80);    TFT.printf(".");

    while(1) {
        while( tocos.getc() != 0x3A );  // 0x3A=":"
        for(int i=0;i<49;i++){
            recv_str[i] = tocos.getc();
        }
        recv_str[49]=NULL;
        // 78811501B781003BB6782A05000B291B000033FFFFFFFFA3
        // 012345678901234567890123456789012345678901234567
        strncpy( ad1_str  , recv_str+36 , 2 );
        strncpy( ad1h_str , recv_str+44 , 2 );
        strncpy( v_id_str , recv_str+10 , 8 );
        strncpy( v_lg_str , recv_str+18 , 2 );
        strncpy( tmp_str  , recv_str+8  , 2 );
        v_lqi=strtol(tmp_str,NULL,16);
        strncpy( tmp_str  , recv_str+26 , 4 );
        v_bat=strtol(tmp_str,NULL,16);
        tmp_str[2]=NULL;
        ad1 = strtol(ad1_str,NULL,16);
        ad1h= strtol(ad1h_str,NULL,16) & 0x03;
        ad1 = (ad1 * 4 + ad1h) * 4;
        lm61= ad1 - 600 ;
        myled = 0;
        
        if( strcmp(v_id_str,child1)==0 ){
            vpos_offset=0;
        } else {
            vpos_offset=80;
        }
        TFT.foreground( White );
        TFT.set_font( (unsigned char *) Prototype24x34 );
        TFT.locate(  0,18+vpos_offset);
        TFT.printf("% 2d",lm61/10);
        TFT.locate( 82,18+vpos_offset);
        if(lm61<0){
            TFT.printf("%d",(-1*lm61 % 10) );
        } else {
            TFT.printf("%d",(lm61 % 10) );
        }
        TFT.set_font( (unsigned char *) Consolas9x16 );
        TFT.foreground( Yellow );
        TFT.locate( 0,  0+vpos_offset);TFT.printf("%s(%2d%%)",v_id_str,(int)((float)v_lqi/255*100) );
        TFT.foreground( Cyan );
        TFT.locate( 0, 54+vpos_offset);TFT.printf("VBAT=%4.2fV",(float)v_bat/1000 );
        
        myled = 1;
    }
}
