//※必ずmbedライブラリのリビジョンは122以前を使用すること
//※ I2Cで読んだ角度とA/B相のエンコーダ角度の回転方向は一致させること
#ifndef MAGNETIC_ENCORDER_H
#define MAGNETIC_ENCORDER_H

#include "rotary_encoder_ab_phase.hpp"
#include "AS5601.h"

#define PCA9547_ADDR 0x70 //7bit

class MagneticEncorder {
    public:
        MagneticEncorder(TIM_TypeDef* timer_type,PinName sda,PinName scl, char _motor_addr=0, int ppr_val=PPR2048, float offset_val=0);
        //timer_typeはTIM1~5の値を入れる(rotary_encoder)
        //motor_addrはモーター番号．これを基にモーターを識別する(0~7)
        //pprはAS5601.hを参照
        /*offsetはオフセットとして設定する値．出力値を見て決定．
        */
        //IC-磁石の方向に見た時,時計回転方向を正方向とする(※内部では反時計回りで処理していることに注意!)
        
        float calibAngle();  //磁気エンコーダからI2Cで絶対角度を取得・補正する(割り込み中は使用不可)
        
        float readAngle();  //A/B相エンコーダにより絶対角度を取得する(0~360deg)
    
    private:
        AS5601 as5601;
        rotary_encoder_ab_phase enc;
        I2C pca9547;
        
        void changeMotor(); //指定するアドレスに変更
        
        //定数
        char motor_addr;
        int ppr,offset;
        
        //I2C取得値,AB相取得値
        float angle_i2c, angle_ab;
        
};




#endif