#include "magnetic_encorder.h"
#include "mbed.h"
#include "math.h"

MagneticEncorder::MagneticEncorder(TIM_TypeDef* timer_type,PinName sda,PinName scl, char _motor_addr, int ppr_val, float offset_val) : as5601(sda,scl,ppr_val,0) ,enc(timer_type,2048), pca9547(sda,scl)//※encの第2引数「2048」は実際には反映されない
{
        wait(0.1);
        motor_addr = _motor_addr;
        ppr = powf(2,ppr_val+3);
        offset = offset_val;
        
        changeMotor();
        as5601.init();
        
        calibAngle();
        
        //AB相計測スタート
        enc.start();
}
        
void MagneticEncorder::changeMotor(){
    char data = 0x08 + motor_addr;
    pca9547.write(PCA9547_ADDR*2,&data,1);
    wait(0.001);
}
        
float MagneticEncorder::calibAngle(){
    changeMotor();
    angle_i2c = as5601.getAngleDegrees();
    angle_ab = 0;
    
    return angle_i2c;
}

float MagneticEncorder::readAngle(){
    angle_ab = enc.get_counts()*360.0f/ppr;
    float angle = angle_ab + angle_i2c;
    angle = 180 - angle;    //時計回り方向に修正
    angle -= offset;        //offset分を修正
    if(angle < 0) angle += 360;
    if(angle > 360) angle -= 360;
    
    return angle;
}