#include <iostream>
#include <string>
#include <cstring>
#include <ctime>

class HistoryCache
{

public:
    static char *strptime(const char * __restrict, const char * __restrict, struct tm * __restrict);
   
   static std::string getTimeStamp(time_t epochTime, const char* format = "%Y-%m-%d %H:%M:%S")
   {
      char timestamp[64] = {0};
      strftime(timestamp, sizeof(timestamp), format, localtime(&epochTime));
      return timestamp;
   }

   static time_t convertTimeToEpoch(const char* theTime, const char* format = "%Y-%m-%d %H:%M:%S")
   {
      std::tm tmTime;
      memset(&tmTime, 0, sizeof(tmTime));
      HistoryCache::strptime(theTime, format, &tmTime);
      return mktime(&tmTime);
   }
};
