#ifndef UBLOX_NAV_H
#define UBLOX_NAV_H

#include "mbed.h"
#include "obsvdStruct.h"

#define TIMEUTC_LEN 20
#define POSLLH_LEN 28
#define VELNED_LEN 36

/*

//sample program

#include "mbed.h"
#include "ubloxUBX.h"

GPS gps(PB_5,PB_4,PB_3,PB_6);
Serial pc(USBTX,USBRX);



obsvdData obsvd;
tim gt;


int main() {

    while(1) {
        while(gps.updateData()); //upload from ublox module
        gps.chkData(&obsvd);          //position and velocity data update
        gps.chkTime(&gt);             //time data update
        
        pc.printf("%d,%d,%d,%d\r\n",obsvd.Lon,obsvd.Lat,gt.Year,gt.Month);
        wait(0.1);
    }
}



*/

typedef union{
    unsigned char Raw[TIMEUTC_LEN];
    struct{
        unsigned int iTOW;
        unsigned int tAcc;
        int nano;
        unsigned short year;
        unsigned char month;
        unsigned char day;
        unsigned char hour;
        unsigned char min;
        unsigned char sec;
        unsigned char valid;
    }Data;
} bufToTIMEUTC;

typedef union{
    unsigned char Raw[POSLLH_LEN];
    struct{
        unsigned int iTOW;
        int lon; //1e-7
        int lat; //1e-7
        int height;
        int hMSL;
        unsigned int hAcc;
        unsigned int vAcc;
    }Data;
} bufToPOSLLH;

typedef union{
    unsigned char Raw[VELNED_LEN];
    
    struct{
        unsigned int iTOW;
        int velN;
        int velE;
        int velD;
        unsigned int speed;
        unsigned int gspeed;
        int heading;
        unsigned int sAcc;
        unsigned int cAcc;
        
    }Data;
    
} bufToVELNED;



class GPS {

public:
    
    GPS(PinName mosi,PinName miso,PinName sck,PinName _cs);
    
    bool updateData();
    
    void chkData(obsvdData* obs);
    
    void chkTime(timData* t);
    
    

private:
    SPI _gps;
    DigitalOut cs;
    
    bufToTIMEUTC timeData;
    bufToPOSLLH posData;
    bufToVELNED velData;
    unsigned char buf0[50];
    unsigned char buf1[50];
    unsigned char buf2[50];

};




#endif