#include "ubloxUBX.h"


GPS::GPS(PinName mosi,PinName miso,PinName sck,PinName _cs):_gps(mosi,miso,sck),cs(_cs){
    cs=1;
    _gps.frequency(5500000);
}

bool GPS::updateData(){
    bool flag=false;
    
    cs=0;
        
    //読み込みバッファ
    static unsigned char val[2];
    
    val[0]=val[1];
    val[1]=_gps.write(0xFF);
    
    if(val[0]==0xb5&&val[1]==0x62){
        
        flag=true;                          //flagをtrueに
        
        buf0[0]=val[0];
        
        for(int i=1;i<50;i++){
            
            //読み込みバッファ更新
            val[0]=val[1];
            val[1]=_gps.write(0xFF);
            
            if(val[0]==0xb5&&val[1]==0x62){
                i=0;
                for(int j=0;j<50;j++) buf2[j]=buf1[j];
                for(int j=0;j<50;j++) buf1[j]=buf0[j];
         
            }
            
            buf0[i]=val[0];

        }
        
        
        //GPSモジュールから来たデータを読み取り構造体に代入
        for(int i=6;i<TIMEUTC_LEN+6;i++){
            timeData.Raw[i-6]=buf0[i];
        }
        
        
        for(int i=6;i<VELNED_LEN+6;i++){
            velData.Raw[i-6]=buf1[i];
        }
        
        
        for(int i=6;i<POSLLH_LEN+6;i++){
            posData.Raw[i-6]=buf2[i];
        }
        
    }
    
    cs=1;
    
    return flag;
    
}

void GPS::chkData(obsvdData *obs){
    
    obs->Lon=posData.Data.lon;
    obs->Lat=posData.Data.lat;
    obs->GHeight=posData.Data.height;
    
    obs->VelN=velData.Data.velN;
    obs->VelE=velData.Data.velE;
    obs->VelD=velData.Data.velD;

}

void GPS::chkTime(timData* t){
    t->Year=(int)timeData.Data.year;
    t->Month=(int)timeData.Data.month;
    t->Day=(int)timeData.Data.day;
    t->Hour=(int)timeData.Data.hour+9; //日本標準時に変換
    t->Min=(int)timeData.Data.min;
    t->Sec=(int)timeData.Data.sec;
}
