#ifndef BMP280_H
#define BMP280_H
/*
#include "mbed.h"

#include "BMP280.h"

BMP280 bmp(D11,D12,D13,D10);

int main() {
    
    bmp.init(OSR_1,OSR_4,IIR_0);
    
    
    while(1) {
    while(bmp.update()!=1);
    printf("%f\r\n",bmp.getpress());
    wait(0.1);
    }
}
*/

#define OSR_1 0b001
#define OSR_2 0b010
#define OSR_4 0b011
#define OSR_8 0b100
#define OSR_16 0b101

#define IIR_0 0b000
#define IIR_4 0b100
#define IIR_16 0b111



#include "mbed.h"

class BMP280 {

public:
    BMP280(PinName mosi,PinName miso,PinName sck,PinName _cs);
    void init(char t_osr,char p_osr,char IIR);
    char readbyte(char adr);
    void writebyte(char adr,char data);
    void readnbyte(char adr,char *data,char num);
    
    int bmp280_compensate_T_int32(int adc_T);
    unsigned int bmp280_compensate_P_int64(int adc_P);
    bool update();
    unsigned int getpress();
    

private:
    SPI bmp;
    DigitalOut cs;
    int t_fine;
    unsigned short dig_T1,dig_P1;
    short dig_T2,dig_T3,dig_P2,dig_P3,dig_P4,dig_P5,dig_P6,dig_P7,dig_P8,dig_P9;
    unsigned int press;
    
    char _t_osr;
    char _p_osr;
    char _IIR;
    

};




#endif