#include "BMP280.h"


BMP280::BMP280(PinName mosi,PinName miso,PinName sck,PinName _cs):bmp(mosi,miso,sck),cs(_cs)
{
    cs=1;
    bmp.frequency(10000000);
    bmp.format(8,3);
    
    wait(0.1);
    press=0;
    
    writebyte(0xe0,0xb6);//reset
    wait_ms(100);
    
    char buf[2];
    while((readbyte(0xf3)&0b00000001));
    
    readnbyte(0x88,buf,2);
    dig_T1=((unsigned short)(buf[1]<<8)|buf[0]);
    readnbyte(0x8a,buf,2);
    dig_T2=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x8c,buf,2);
    dig_T3=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x8e,buf,2);
    dig_P1=((unsigned short)(buf[1]<<8)|buf[0]);
    readnbyte(0x90,buf,2);
    dig_P2=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x92,buf,2);
    dig_P3=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x94,buf,2);
    dig_P4=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x96,buf,2);
    dig_P5=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x98,buf,2);
    dig_P6=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x9a,buf,2);
    dig_P7=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x9c,buf,2);
    dig_P8=((short)(buf[1]<<8)|buf[0]);
    readnbyte(0x9e,buf,2);
    dig_P9=((short)(buf[1]<<8)|buf[0]);

}

void BMP280::init(char t_osr,char p_osr,char IIR){
    _t_osr=t_osr;
    _p_osr=p_osr;
    _IIR=IIR;
    
    //forced mode trigger
    char data=((t_osr<<5)|(p_osr<<2))|0b01;
    writebyte(0xf4,data);//config
    
    data=0;
    data=(IIR<<2);
    writebyte(0xf5,data);
}

char BMP280::readbyte(char adr){
    cs=0;
    bmp.write(adr|0b10000000);
    char val=bmp.write(0xff);
    cs=1;
    return val;
    
}
void BMP280::writebyte(char adr,char data){
    cs=0;
    bmp.write(adr&0b1111111);
    bmp.write(data);
    cs=1;
}
void BMP280::readnbyte(char adr,char *data,char num){
    cs=0;
    bmp.write(adr|0b10000000);
    for(int i=0;i<num;i++)data[i]=bmp.write(0xff);
    cs=1;
}

int BMP280::bmp280_compensate_T_int32(int adc_T){
    int var1,var2,T;
    var1=((((adc_T>>3)-((int)dig_T1<<1)))*((int)dig_T2))>>11;
    var2=(((((adc_T>>4)-((int)dig_T1))*((adc_T>>4)-((int)dig_T1)))>>12)*((int)dig_T3))>>14;
    t_fine=var1+var2;
    T=(t_fine*5+128)>>8;
    return T;
    
}
unsigned int BMP280::bmp280_compensate_P_int64(int adc_P){
    int32_t var1, var2;
    unsigned int press=0;
 
    var1 = (t_fine >> 1) - 64000;
    var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * dig_P6;
    var2 = var2 + ((var1 * dig_P5) << 1);
    var2 = (var2 >> 2) + (dig_P4 << 16);
    var1 = (((dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((dig_P2 * var1) >> 1)) >> 18;
    var1 = ((32768 + var1) * dig_P1) >> 15;
    if (var1 == 0) {
        return 0;
    }
    press = (((1048576 - adc_P) - (var2 >> 12))) * 3125;
    if(press < 0x80000000) {
        press = (press << 1) / var1;
    } else {
        press = (press / var1) * 2;
    }
    var1 = ((int32_t)dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
    var2 = (((int32_t)(press >> 2)) * (int32_t)dig_P8) >> 13;
    press = (press + ((var1 + var2 + dig_P7) >> 4));
    
    return press;
}
bool BMP280::update(){
    if(((readbyte(0xf3)&0b00001000)>>3)==0){//データが見れるか
    
    char data[6];
    int adc_T,adc_P;
    readnbyte(0xf7,data,6);
    adc_T=(int)((data[4]<<4)|(data[3]<<12))|(data[5]>>4);
    
    adc_P=(int)((data[2]>>4)|(data[1]<<4))|(data[0]<<12);
    
    //forced mode trigger
    char buf=((_t_osr<<5)|(_p_osr<<2))|0b01;
    writebyte(0xf4,buf);//config
    buf=(_IIR<<2);
    writebyte(0xf5,buf);
    
    bmp280_compensate_T_int32(adc_T);
    press=bmp280_compensate_P_int64(adc_P);

    
    
    return true;
    }else return false;
    
}

unsigned int BMP280::getpress(){
    return press;
}