//春ロボコン上半身
//最終更新2020年03月16日

#include "mbed.h"
#include "QEI.h"
#include "counter.h"
#include "haru_defines.h"
#include "string"
using std::string;

Ticker PID_control;
Timer t;

Serial pc(USBTX,USBRX,115200);
Serial gr(p9,p10,115200);
RawSerial MD1(p13,NC,115200);
//RawSerial MD2(p28,NC,115200);

//**電磁弁**//
DigitalOut object_hand(p21);
DigitalOut box_set(p22);
DigitalOut suction(p23);
DigitalOut blow(p24);
DigitalOut up_down(p25);

//**スイッチ**//
DigitalIn sw_Yellow(p30);
DigitalIn sw_origin(p11);
//DigitalIn sw_frontR(p12);
//DigitalIn sw_frontL(p14);
//DigitalIn sw_p15(p15);
//DigitalIn sw_p16(p16);

//**エンコーダ**//
QEI enc1(p8,p7,NC,RESOLUTION,&t,QEI::X4_ENCODING);
//QEI enc2(p6,p5,NC,RESOLUTION,&t,QEI::X4_ENCODING);

//**カウンタークラス**//
Counter conR1(BUTTON_R1);
Counter conL1(BUTTON_L1);
Counter conA(BUTTON_A);

//**LED**//
DigitalOut yellow_LED(p17);
DigitalOut green_LED(p18);
DigitalOut red_LED(p26);
/*OnBoardLED*/
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

//**コントローラー関連**//
char c;
string recv_str = "";
int recv_data = 0;
bool flag_10ms = false;
int pre_sw_yellow = 1;
int count_sw_yellow = 0;

//**PID制御関連**//
double target_velocity = 0.0,target_position = 0.0;
double pre_error_velocity = 0.0, pre_error_position = 0.0;
double speed = 0.0;
double Kvp = 4.5, Kvi = 0.0, Kvd = 0.005;
double Kxp = 0.002, Kxi = 0.0, Kxd = 0.005; 
/*PID変数確認*/
double velocity;
double error_velocity;
double error_position;
double angle;
double position;
double next_position;
double pre_speed = 0.0;
double max_vel = 35.0;

//**その他**//
bool flag_led = true;
bool flag_blow = true;
bool flag_ship = false;
bool flag_box = false;
float led_num = 0;
int count_led = 0;
float a = 0.12 ;

//**値を最大最小に抑える**//
double min_max(double value, double minmax){
  if(value > minmax) value = minmax;
  else if(value < -minmax) value = -minmax;
  return value;
}

//**OnBoardLED**//
void myled(int a,int b, int c, int d){
    myled1 = a;
    myled2 = b;
    myled3 = c;
    myled4 = d;
}

//**コントローラー受信**//
void func_recive(void)
{
    c = gr.getc();
    if(c == '\n') {
        if(recv_str.length() >= 4){
            recv_data = strtol(recv_str.c_str(), NULL, 16);
            recv_str = "";
        }
    } else {
        recv_str += c;
    }
}

//**速度PID制御**//
void MD1A_velocity(void){
    velocity = PULLEY_R*enc1.getRPS();
    if(target_velocity != 0.0){
        error_velocity = target_velocity - velocity;//誤差を計算
        //Iv += ((errorv + pre_errorv)/2.0)*0.01;//誤差を積分
        pre_speed += Kvp*error_velocity + Kvd*(error_velocity - pre_error_velocity)/WARIKOMI_TIME;
        speed = min_max(pre_speed,SPEED_MAX*0.7);
        pre_error_velocity = error_velocity;//誤差の更新
    }
    else speed = 0.0;
    //**初期化動作確認LED**//
    if(flag_led) count_led++;
    if(count_led >= 30){
        yellow_LED = !yellow_LED;
        count_led = 0;
    }
    flag_10ms = true;
}

//**位置PID制御**//
void MD1A_position(void){
    angle = (double)enc1.getPulses() *2.0*PIE/(4.0*RESOLUTION);
    position = angle*PULLEY_R;
    error_position = target_position - position;//誤差を計算
    next_position = position;//poshition の更新
    //Ip += ((errorx + pre_errorx)/2.0)*0.01;//誤差を積分
    next_position += Kxp*error_position + Kxd*(error_position - pre_error_position);//PID
    pre_error_position = error_position;//誤差を更新
    double velocity;
    velocity = (next_position - position)/ WARIKOMI_TIME;
    target_velocity = min_max(velocity,max_vel);
    MD1A_velocity();
    //**LPCのLEDをいい感じに光らせる**//
    led_num += WARIKOMI_TIME;
    if(led_num > a*6.0) led_num = 0;
}

int main(){
    //**初期化**//
    object_hand = 0; box_set = 0; suction = 0;blow = 0; up_down = 0;
    red_LED = 0; yellow_LED = 1; green_LED = 0;
    
    //**受信とスタンバイ**//
    gr.attach(&func_recive,Serial::RxIrq);
    while(~recv_data & BUTTON_START && sw_Yellow.read() != 0) {
        if(sw_origin.read() != 1) yellow_LED = 0;
        else yellow_LED = 1;
    }
    
    //**昇降機構の原点出し**//
    enc1.qei_reset();
    PID_control.attach(&MD1A_velocity,WARIKOMI_TIME);
    target_velocity = -10.0;
    while(sw_origin.read() != 0){
        if(flag_10ms){
            MD1.printf("M1:%d\r\n",(int)speed);
            flag_10ms = false;
        }
    }
    MD1.printf("M1:0\r\n");
    PID_control.detach();
    target_velocity = 0.0; speed = 0.0; pre_speed = 0; pre_error_velocity = 0.0;
    
    //**昇降機構スタンバイ**//
    target_position = 120.0;
    enc1.qei_reset();
    yellow_LED = !yellow_LED;
    wait(0.5);
    PID_control.attach(&MD1A_position,WARIKOMI_TIME);
    while(position < 110.0){
        if(flag_10ms){
            MD1.printf("M1:%d\r\n",(int)speed);
            flag_10ms = false;
        }
    }
   
    //**スタート直前**//
    flag_led = false; yellow_LED = 0; green_LED = 1; box_set = 1;
    int suctionM = 0;

    while(1) {
            //**コントローラー関連**//
            if(recv_data != 0) red_LED = 1;
            else red_LED = 0;
            conA.getCount(recv_data,CON);conR1.getCount(recv_data,CON);conL1.getCount(recv_data,CON);
            
            //**物資関連**//
            object_hand = conR1.getCounts() % 2; 
            up_down = conL1.getCounts() % 2;
            
            //**移住船関連**//
            if(conA.getCounts() % 2 == 0){
                suction = 1;
                suctionM = 0;
                if(flag_box){
                    box_set = 1;
                    flag_box = false;
                }
            }else{
                suction = 0;
                suctionM = 1800;
            }
            
            //**昇降機構モーター関連**//
            if(recv_data & BUTTON_JOY_R || recv_data & BUTTON_R2)target_position = 170.0;
            else if(recv_data & BUTTON_JOY_L || recv_data & BUTTON_L2) target_position = 0.0;
            /*移住船関連*/
            if(position <= 95.0) box_set = 0;
            else if(target_position == 100.0) box_set = 1;            
            if(suctionM == 1800 && position >= 160) flag_box = true;
            
                            
            if(flag_10ms){
                int refV;
                if(target_position == 0.0 && sw_origin != 1) refV = 0;
                else if(target_position == 170.0 && position >= MAX_POSI) refV = 0;
                else refV = (int)speed;
                MD1.printf("M1:%d\r\n",refV);
                MD1.printf("M2:%d\r\n",suctionM);
                pc.printf("%lf\n",target_position);
            
                if(led_num >= a*5.0) myled(0,1,0,0);
                else if(led_num >= a*4.0) myled(0,0,1,0);
                else if(led_num >= a*3.0) myled(0,0,0,1);
                else if(led_num >= a*2.0) myled(0,0,1,0);
                else if(led_num >= a*1.0) myled(0,1,0,0);
                else if(led_num >= a*0.0) myled(1,0,0,0);
                
                flag_10ms = false;
            }
    }
}
