#include "mbed.h"
#include "Controller.h"
#include "Filter.h"

#define INT_TIME 0.01
Filter joyRX_filter(INT_TIME);
Filter joyRY_filter(INT_TIME);
Filter joyLX_filter(INT_TIME);
Filter joyLY_filter(INT_TIME);

Controller Con(p28,p27,115200);
Serial pc(USBTX,USBRX,115200);

int main()
{
    joyRX_filter.setLowPassPara(0.16,0.0);
    joyRY_filter.setLowPassPara(0.16,0.0);
    joyLX_filter.setLowPassPara(0.16,0.0);
    joyLY_filter.setLowPassPara(0.16,0.0);
    
    while(1) {
        double joyRX = joyRX_filter.LowPassFilter(Con.readJoyRXbyte());
        double joyRY = joyRY_filter.LowPassFilter(Con.readJoyRYbyte());
        double joyLX = joyLX_filter.LowPassFilter(Con.readJoyLXbyte());
        double joyLY = joyLY_filter.LowPassFilter(Con.readJoyLYbyte());
        unsigned int buttonstate = Con.getButtonState();
        if(buttonstate & BUTTON_MARU) pc.printf("%d\n",Con.getButtonState());
        else if(buttonstate & BUTTON_L2) pc.printf("%3.0lf %3.0lf %3.0lf %3.0lf\n",joyRX,joyRY,joyLX,joyLY);
        else pc.printf("PUSH!\n");
        //wait(0.01);
    }
}
