#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "mbed.h"
#include "RawSerial.h"

#define BUTTON_SIKAKU 0x01
#define BUTTON_SANKAKU 0x02
#define BUTTON_BATU 0x04
#define BUTTON_MARU 0x08
#define BUTTON_L1 0x10
#define BUTTON_R1 0x20
#define BUTTON_L2 0x40
#define BUTTON_R2 0x80
#define BUTTON_PAD 0x100
#define BUTTON_PS 0x200
#define BUTTON_SHARE 0x400
#define BUTTON_OPTION 0x800
#define BUTTON_UP 0x1000
#define BUTTON_RIGHT 0x2000
#define BUTTON_DOWN 0x4000
#define BUTTON_LEFT 0x8000

class Controller
{
public:
    Controller(PinName tx, PinName rx, int baudrate);
    RawSerial XBee3;
    //Controller(RawSerial* serial_xbee);

    void update();
    //void DRbegin();

    /**
     * コントローラのボタン入力状態を返す．
     * 
     * @param buttonNum ボタン番号 1~12
     * @return 1:押されている 0:離されている 2:押された -1:離された
     * 
     */
    
    int8_t readButton(int buttonNum) const;
    unsigned int getButtonState() const;

    /**
     * ジョイスティックの値を読む
     * @return -1.0 ~ 1.0
     * 
     *      X
     *      ^
     *      |
     * Y<---+----
     *      |
     *      |
     */
    
    double readJoyLX() const;
    double readJoyLY() const;
    double readJoyRX() const;
    double readJoyRY() const;

    unsigned int readJoyLXbyte() const;
    unsigned int readJoyLYbyte() const;
    unsigned int readJoyRXbyte() const;
    unsigned int readJoyRYbyte() const;

    bool getButtonChanged() const; //スイッチの状態を確認する


private:

    unsigned int ButtonState, preButtonState;
    unsigned int LJoyX, LJoyY, RJoyX, RJoyY;
    int boudrate;

    bool buttonChanged;
    

private:
    int recv_num;

    char recv_msgs[9];
};

#endif