#include "mbed.h"
#include "Controller.h"

Serial pc(USBTX,USBRX,115200);
Ticker timer;
DigitalOut myled2(LED2);

XBee_APIMode Con(p28,p27);

bool flag_10ms = false;
bool flag_1s = false;

void warikomi(){
    flag_10ms = true;
    static int a = 0;
    if(a++ > 100){
        flag_1s = true;
        a = 0;
    }
}

void setup()
{   
    wait(1);
    myled2.write(0);
    Con.begin(115200);
    timer.attach(warikomi,0.01);
}

void loop()
{
    int serial_num = Con.update();
    if(flag_10ms)
    {
        pc.printf("%d\t%d\n",serial_num,Con.getButtonState());
        
        flag_10ms = false;
    }
    if(flag_1s)
    {
        myled2.write(!myled2.read());
        flag_1s = false;
    }
}
    
int main(void)
{
    setup();
    for(;;)loop();
    return 0;
}
