#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "mbed.h"
#include "XBee.h"
#include "RawSerial.h"

#define APIMODE 1
#define TRANSPARENT_MODE 2

#define XBEE_MODE ( APIMODE ) //カッコの中を変えて使う

#if XBEE_MODE == TRANSPARENT_MODE
 
    #define BUTTON_X  0x0001
    #define BUTTON_Y  0x0002
    #define BUTTON_A  0x0004
    #define BUTTON_B  0x0008
    
    #define BUTTON_L1     0x0010
    #define BUTTON_R1     0x0020
    #define BUTTON_L2     0x0040
    #define BUTTON_R2     0x0080
    
    // #define BUTTON_JOY_L   0x0100
    // #define BUTTON_JOY_R   0x0200
    // #define BUTTON_SHARE    0x0400
    // #define BUTTON_OPTION   0x0800
    #define BUTTON_PAD 0x0100
    #define BUTTON_PS 0x0200
    #define BUTTON_JOY_L 0x0400
    #define BUTTON_JOY_R 0x0800
    
    #define BUTTON_UP     0x1000
    #define BUTTON_RIGHT  0x2000
    #define BUTTON_DOWN   0x4000
    #define BUTTON_LEFT   0x8000

#elif XBEE_MODE == API_MODE

    #define BUTTON_SQUARE   0x0001
    #define BUTTON_TRIANGLE 0x0002
    #define BUTTON_CROSS    0x0004
    #define BUTTON_CIRCLE   0x0008
    
    #define BUTTON_L1   0x0010
    #define BUTTON_R1   0x0020
    #define BUTTON_L2   0x0040
    #define BUTTON_R2   0x0080
    
    #define BUTTON_UP     0x0100
    #define BUTTON_RIGHT  0x0200
    #define BUTTON_DOWN   0x0400
    #define BUTTON_LEFT   0x0800
    
    #define BUTTON_SHARE    0x1000
    #define BUTTON_OPTION   0x2000
    #define BUTTON_PAD      0x4000
    #define BUTTON_PS       0x8000
    
    #define BUTTON_JOY_L    0x0100
    #define BUTTON_JOY_R    0x0200
    
#endif

#define DATA_NUM_TRANS  10
#define DATA_NUM_API    3
#define BOUDRATE_TRANS  115200
#define BOUDRATE_API    230400

#define PUSHE 1
#define RELEASE 0
#define PUSHED 2
#define RELEASED -1

class XBee_TransparentMode
{
public:
    XBee_TransparentMode(PinName tx,PinName rx,int baudrate);

    void update();
    
    bool readButton(unsigned int button,int status);
    unsigned int getButtonState();
    
    unsigned int ButtonState, preButtonState;
    unsigned int LJoyX, LJoyY, RJoyX, RJoyY;


private:

    int boudrate;
    RawSerial serialXbee3;

    bool buttonChanged;
    

private:
    int recv_num;
};

class  XBee_APIMode
{
public:
    XBee_APIMode(PinName tx,PinName rx);
    
    void begin(int baudrate);
    int update();
    
    bool readButton(unsigned int button,int status);
    unsigned int getButtonState();
    
    unsigned int ButtonState, preButtonState;

private:

    int boudrate;
    XBee xbee;

    bool buttonChanged;
};

#endif