#include "Controller.h"
#include "mbed.h"
#include "RawSerial.h"
#include "XBee.h"

DigitalOut myled1(LED1);
XBeeResponse response = XBeeResponse();
ZBRxResponse xbee_rx = ZBRxResponse();

XBee_APIMode::XBee_APIMode(PinName tx,PinName rx):xbee(tx,rx)
{
    ButtonState = 0;
    myled1 = 0;
}

XBee_TransparentMode::XBee_TransparentMode(PinName tx,PinName rx,int baudrate) :serialXbee3(tx,rx)
{
    serialXbee3.baud(baudrate);
    serialXbee3.attach(this,&XBee_TransparentMode::update,Serial::RxIrq);
    ButtonState = 0;
    LJoyX = 127;
    LJoyY = 127;
    RJoyX = 127;
    RJoyY = 127;
    myled1 = 0;
}

void XBee_TransparentMode::update()
{   
    unsigned int checksum;
    char c;
    char recv_msgs[DATA_NUM_TRANS];

    c = serialXbee3.getc();
    if (c == '\n') {

        if (recv_num == 10) {
            checksum = 0;

            for (int i = 0; i < (DATA_NUM_TRANS - 1); i++) {
                recv_msgs[i] = recv_msgs[i] - 0x20;
                checksum += (unsigned int)recv_msgs[i];
            }

            if ((checksum & 0x3F) == (recv_msgs[9] - 0x20)) {
                myled1 = !myled1;
                ButtonState = 0;

                ButtonState |= recv_msgs[0] & 0x3F;
                ButtonState |= (recv_msgs[1] & 0x3F) << 6;
                ButtonState |= (recv_msgs[2] & 0x0F) << 12;

                LJoyX = recv_msgs[3];
                LJoyX |= (recv_msgs[4] & 0x03) << 6;

                LJoyY = (recv_msgs[4] & 0x3C) >> 2;
                LJoyY |= (recv_msgs[5] & 0x0F) << 4;

                RJoyX = (recv_msgs[5] & 0x30) >> 4;
                RJoyX |= (recv_msgs[6] & 0x3F) << 2;

                RJoyY = recv_msgs[7];
                RJoyY |= (recv_msgs[8] & 0x03) << 6;
                
                preButtonState = ButtonState;
            }
        }
        recv_num = 0;
    } else {
        recv_msgs[recv_num++] = c;
    }
}

void XBee_APIMode::begin(int baudrate){
    xbee.begin(baudrate);
}
int XBee_APIMode::update()
{
    uint8_t recv_val[DATA_NUM_API] = {};
    xbee.readPacket();
    static int getResponse_getApiId = 0;
    int getResponse_isAvailable = xbee.getResponse().isAvailable();
    if (getResponse_isAvailable) {
        getResponse_getApiId = xbee.getResponse().getApiId();
        if (getResponse_getApiId == ZB_RX_RESPONSE) {
            xbee.getResponse().getZBRxResponse(xbee_rx);
            for(int i = 0; i < DATA_NUM_API; i++){
                recv_val[i] = (uint8_t)xbee_rx.getData(i);
            }
                preButtonState = ButtonState;
                myled1 = !myled1;
                
                ButtonState = 0;
                ButtonState |= recv_val[0] & 0xFF;
                ButtonState |= (recv_val[1] & 0xFF) << 8;
                ButtonState |= (recv_val[2] & 0xFF) << 16;
                
        }
    }else{
        //getResponse_getApiId = 9999;
    }
    return getResponse_getApiId;
}
unsigned int XBee_TransparentMode::getButtonState()
{
    return ButtonState;
}
unsigned int XBee_APIMode::getButtonState()
{
    return ButtonState;
}

bool XBee_TransparentMode::readButton(unsigned int button,int status)
{
  int8_t num = 0;
  if(ButtonState & button)  num += 2;
  if(preButtonState & button) num -= 1;
  if(num == status) return true;
  else return false;
}
bool XBee_APIMode::readButton(unsigned int button,int status)
{
  int8_t num = 0;
  if(ButtonState & button)  num += 2;
  if(preButtonState & button) num -= 1;
  if(num == status) return true;
  else return false;
}