//宇井コンとの通信をmbedで行えるように変更を加えたクラスでプロジェクトに公開していない．
#ifndef CONTROLLERFORMBED_H
#define CONTROLLERFORMBED_H

#include "mbed.h"
#include "RawSerial.h"
#include "define.h"
/*
struct ControllerData{
    unsigned int ButtonState;
    uint8_t RJoyX, RJoyY, LJoyX, LJoyY;
};
*/
class ControllerForMbed{
    public:
        ControllerForMbed(PinName tx, PinName rx, int baudrate);

        bool readButton_bin(unsigned int ButtonNum); //押していない時はfalse(0),押してるときはtrue(1)を返す．　ButtonNumはデータの欲しいボタンの名前を
        int  readButton(unsigned int ButtonNum);     //上にプラスして 押した瞬間は2，放した瞬間は-1を返す．    define.hを参考に数字を入力しても良い
        bool getComCheck(void); //値が更新されたときにtrueを返す．
        bool update(); //受信の処理＋ボタンの情報の更新．受信割込みで処理

        void init(int _time_out_ms, int _int_time_ms); //コントローラの通信速度と通信のタイムアウト時間を設定
        bool available(void); //コントローラーと通信できていたらtrueを返す．

        unsigned int getButtonState();  //分解する前のButtonStateの情報をprint 0~255の値をとる
        void clearButtonState();
        ControllerData getConData();
        unsigned int getButtonFlagRise();
        unsigned int getButtonFlagFall();
    
                                //       X
        double readJoyRX();     //       ^ 
        double readJoyRY();     //       | 
        double readJoyLX();     //  Y<---+----
        double readJoyLY();     //       | 
                                //       | 
                                //  1.0  ~   -1.0

                                   //       X
        uint8_t readJoyRXbyte();   //       ^ 
        uint8_t readJoyRYbyte();   //       |
        uint8_t readJoyLXbyte();   //  Y<---+----
        uint8_t readJoyLYbyte();   //       | 
                                   //       |
                                   //  255  ~    0

    private:
        
        RawSerial serial;
        //Timer timer;

        bool comCheck;
        ControllerData conData;
        ControllerData pre_conData;
        unsigned int lastButtonState;

        int time_out_ms; //通信のタイムアウト[ms]
        double int_time_ms; //update関数の呼び出し周期[ms]
        bool conAvailable; //コントローラ接続確認

        uint8_t serial_recieve(){
            char temp;
            do{
                temp = serial.getc();
            }
            while(temp==-1);
            //CONTROL.write(temp);    //受け取ったデータをTXピンからそのまま送っている．他のマイコンにも流したいとき用．
            return temp;
        }
};

#endif

