#include "mbed.h"
#include "omuni.h"
#include "ds3_si.h"
#define DEBUG 1

#define CON_OFFSET 15

I2C i2c(p28, p27);
omuni omu(&i2c, 0x10, 0x14, 0x16);

Serial pc(USBTX, USBRX);
ds3_si con(p9,p10,2400);

BusOut serialsel(LED1,LED2,LED3,LED4);
Timer serialtimer;
//Ticker readtimer;

char ConData[5];

/*
void mbedreset()
{
    NVIC_SystemReset();
}
*/

void GetData()
{
    __disable_irq();
    NVIC_ClearPendingIRQ(UART0_IRQn);
    NVIC_ClearPendingIRQ(UART1_IRQn);
    NVIC_ClearPendingIRQ(UART2_IRQn);
    NVIC_ClearPendingIRQ(UART3_IRQn);
    static bool main_flag = 1 ;
    if ( pc.getc() == 'H' ) {
        ConData[0] = 'H';
        for (int i = 1; i < 5; i++)
        {
         char t = (char)pc.getc();
         ConData[i] = t;
        }
        if(main_flag)
        {
            serialtimer.start();
            main_flag = 0;
        }
            
        serialtimer.reset();
    }
    __enable_irq();
}
#define deadZone 2
bool triggerAnalog(){
    return abs(con.analogstate(L3x)) > deadZone || abs(con.analogstate(L3y))  > deadZone 
    || abs(con.analogstate(R3y))  > deadZone || abs(con.analogstate(R3y)) > deadZone;
}

char MotorReset[] = {'H', 0, 0, 0, 0};
int main() {
        serialsel = 0x05;
        pc.baud(115200);
        pc.attach(&GetData,Serial::RxIrq);
        
        serialtimer.stop();
        serialtimer.reset();
        
        while(1){
            
            wait(0.01);
            int8_t MotorData[] = {'H', ConData[1], ConData[2], ConData[3], ConData[4]};
            MotorData[3] = con.analogstate(L3x);
            MotorData[4] = con.analogstate(L3y);
            MotorData[1] = con.analogstate(R3x);
            MotorData[2] = con.analogstate(R3y);
            if(serialtimer.read_ms() > 500)
            {
                serialsel = 1;
                omu.out(MotorReset);
            }else{
                if(triggerAnalog() == true){
                    if(ConData[1] == 'S' && ConData[2] == 'T'&& ConData[3] == 'O' && ConData[4] == 'P'){
                        MotorData[4] = MotorData[4] > 0 ? 0 : MotorData[4];  
                        serialsel = 0xF;  
                    }else if(ConData[1] == 'O' && ConData[2] == 'N'&& ConData[3] == 'E'){
                        MotorData[4] = MotorData[4] > 60 ? 60 : MotorData[4]; 
                        if(MotorData[4] > 0) 
                            if(ConData[4] == 'R'){
                                MotorData[1] = 30;
                                MotorData[2] = 0;
                                serialsel = 0x2;
                            }
                            else  if(ConData[4] == 'L')  {
                                MotorData[1] = -30;
                                MotorData[2] = 0;
                                serialsel = 0x4;
                            }
                    }else if(ConData[1] == 'E' && ConData[2] == 'S'&& ConData[3] == 'T'){
                        MotorData[4] = MotorData[4] > 40 ? 40 : MotorData[4]; 
                        if(MotorData[4] > 0) 
                        if(ConData[4] == 'R'){
                            MotorData[1] = 30;
                            MotorData[2] = 0;
                            serialsel = 0x2;
                        }else  if(ConData[4] == 'L')  {
                            MotorData[1] = -30;
                            MotorData[2] = 0;
                            serialsel = 0x4;
                        }else if(ConData[4] == 'G'){
                            MotorData[3] = 0;
                            MotorData[2] = 0;
                        }
                    }else if(ConData[1] == 'F' && ConData[2] == 'R'&& ConData[3] == 'E' && ConData[4] == 'E'){
                            serialsel = 0x0;
                    }
                    omu.out((char*)MotorData);
                }else{
                    serialsel = 1;
                    omu.out(MotorReset);
                }
                /*
                #if DEBUG 
                for(int i = 0; i < 5; i++)
                {
                        pc.printf("%d",MotorData[i]);
                }
                        pc.printf("\n");
                #endif*/
                
            }


        }  
}
