
#ifndef Stepper_H
#define Stepper_H

#include "mbed.h"
#define Front 1
#define Back 2
#define Stop 3
#define Servo 4
#define OFF 0
#define ON 1

int step[4] = {0,1,3,2};

class Stepper
{
protected :
    PinName Pin[2];
    float bias;
    Stepper& operator=(const Motor &m) {
        return *this;
    }

public:

    Stepper(PinName _pin1, PinName _pin2) : input(_pin1,_pin2) {
        Max = 0;
        state = Stop;
        pulse = 0;
        Step = 0;
        intervalTime = 0.1;
        start();
        time = 0;
    }


    Stepper& operator= (float duty) {
        if(duty<-0.01F)
        {
            duty = -0.01 / duty;
            run(Back,duty);
        }
        else if(float(duty)>0.01F)
        {
            duty = 0.01 / duty;
            run(Front,duty);
        }
        else run(Stop,0);
        return *this;
    }
    void start() {
        tick.attach(this,&Stepper::interval,0.01);

    }
    void run(int i,float duty) {
        intervalTime = duty;
        state = i;
    }
    float min,max;
    void setbias_motor(float b) {
        bias=b;
    }
    void duty_max(float Max) {
        max=Max;
    }
    void duty_min(float Min) {
        min=Min;
    }
    void setTarget(int tar)
    {
        target = tar;
    }
    int enable;
    int state;
    int target;
    float Max;
    bool finished;
    int Step;
    float angle;
    int pulse;
    int targetPulse;
    float intervalTime;
    BusOut input;
    Ticker tick;
    double time;
    void interval() {
        /*if(enable == OFF)
        {
            return;
        }*/
        time = time + 0.01;
        if(intervalTime < time) {
            time = 0;
            if(state == Front) {
                Step++;
                if(Step>=4)Step = 0;
                input = step[Step];
                pulse++;

                //printf("%d  %d  ",step[Step],Step);
            }
            if(state == Back) {
                Step--;
                if(Step<=-1)Step = 3;
                input = step[Step];
                pulse--;
            }
            if(state == Servo) {
                if(pulse < target) {
                    Step++;
                    if(Step>=4)Step = 0;
                    input = step[Step];
                    pulse++;

                    //printf("%d  %d  ",step[Step],Step);
                }
                if(pulse > target) {
                    Step--;
                    if(Step<=-1)Step = 3;
                    input = step[Step];
                    pulse--;
                }
            }
        }
    }
};

#endif /* PID_H */
