
#ifndef PID_H
#define PID_H

#include "mbed.h"
class PID
{
protected:
    PID(const PID& p);
    PID& operator=(const PID &p) {
        return *this;
    }
public:

    void PIDctrl();
    void InputLimits(float max,float min);
    void OutputLimits(float max,float min);
    PID(float tauKc, float tauKi, float tauKd ,Timer *T);
    void setbias(float bias_){bias=bias_;}
    float s_dErrIntg ,dErr_prev;
    void start();
    void pid_reset();
    void setInterval(float inter);
    //Getters.
    void stop();
    float dTarget;
    float dPoint;
    // PI制御ゲイン
    float GAIN_P ;//1.5 // 比例ｹﾞｲﾝ
    float GAIN_I ;//2.8 // 積分ｹﾞｲﾝ
    float GAIN_D ;//0.2
    float data;
    double dErrDiff;
    
    float userInt;
    float userDiff;
    float userProp;
    bool intF;
    bool diffF;
    bool propF;
private:
    float bias;
    float OutMax;
    float InMax;
    float OutMin;
    float InMin;
    float OutSpan;
    float InSpan;
    Timer *timer;
    float prev_time;
    float gettime() {
        float a = timer->read()-prev_time;
        prev_time=timer->read();
        return a;
    }
    Ticker T;
    float interval;

};

#endif
