
#ifndef PID_H
#define PID_H

#include "mbed.h"
class PID
{
protected:
    PID(const PID& p);
    PID& operator=(const PID &p) {
        return *this;
    }
    void PIDctrl();
public:
    void InputLimits(float max,float min);
    void OutputLimits(float max,float min);
    PID(float tauKc, float tauKi, float tauKd ,Timer *T);
    void setbias(float bias_){bias=bias_;}
    double s_dErrIntg ,dErr_prev;
    void start();
    void pid_reset();
    void setInterval(double inter);
    //Getters.
    void stop();
    double dTarget;
    double dPoint;
    // PI制御ゲイン
    double GAIN_P ;//1.5 // 比例ｹﾞｲﾝ
    double GAIN_I ;//2.8 // 積分ｹﾞｲﾝ
    double GAIN_D ;//0.2
    double data;
private:
    float bias;
    float OutMax;
    float InMax;
    float OutMin;
    float InMin;
    float OutSpan;
    float InSpan;
    Timer *timer;
    float gettime() {
        static float prev_time;
        float a = timer->read()-prev_time;
        prev_time=timer->read();
        return a;
    }
    //Ticker T;
    float interval;

};

#endif
