#include "mbed.h"
#include <string>

#define end "\r\n"

class esp8266
{
    //AP アクセスポイント
    //ST client
    //APST Server and Client
private:

    Serial *Seri;
    char* buffer;
    int datalen;
    void strChack(char data[]) {
        int f = 0;
        for (;;) {
            if(f >= strlen(data))
            {
                break;
            }
            char a=Seri->getc();
            if(a!=data[f])f=0;
            else f++;

        }
        wait(0.1);
    }
    void Reception() {

        char inputData[100];
        Seri->scanf("%s",inputData);
        //Serial pc(USBTX,USBRX);
        //pc.baud(115200);
        //pc.printf("%s\r\n",inputData);
        if(strstr(inputData,"+IPD,")==NULL) {
            /*
            if(strcmp(x,"0,CONNECT")==0)break;
            if(strcmp(x,"0,CLOSED")==0)break;
            if(strcmp(x,">")==0)break;*/
        } else {
            strtok(inputData,",");
            strtok(NULL,":");
            char *data = strtok(NULL,",");
            strtok(inputData,",");
            char *data_num = strtok(NULL,",");
            datalen = atoi(data_num);
            buffer=data;
            //data = strtok(x,"");
            //buffer = data;
            //pc.printf("%s   , %s ,   %s\r\n",y,data_num,data);
        }
    }
    bool check() {

        //Serial pc(USBTX,USBRX);
        //pc.baud(115200);
        Seri->printf(end);
        bool f = false,ans;
        int i=0;
        while(1) {
            char x = Seri->getc();
            //pc.putc(x);
            if(x=='O')f=true;
            else if(x=='K'&&f==true) {
                ans=true;
                break;
            } else f=false;

            if(x=='F')i=1;
            else if(x=='A'&&i==1)i=2;
            else if(x=='I'&&i==2)i=3;
            else if(x=='L'&&i==3) {
                ans=false;
                break;
            } else i=0;

        }
        wait(0.1);
        return ans;
    }
    bool connected;
public:
    char* get_data(char *datax,int num) {
    get:
        char x[num+2];
        Seri->scanf("%s",x);
        //Serial pc(USBTX,USBRX);
        //pc.baud(115200);
        if(strstr(x,"+IPD,")==NULL) {

            return NULL;
            /*
            if(strcmp(x,"0,CONNECT")==0)break;
            if(strcmp(x,"0,CLOSED")==0)break;
            if(strcmp(x,">")==0)break;*/
        } else {

            strtok(x,",");
            strtok(NULL,":");
            datax = strtok(NULL,",");
            strtok(x,",");
            char *data_num = strtok(NULL,",");
            char len = atoi(data_num);

            if(strcmp(datax,"\r\n")==0)goto get;
            else if(len > num)return NULL;
            //for(int i=0;i<len;i++)
            //    *datax++=*data++;
            //printf("%s\r\n",datax);
            return datax;
            //data = strtok(x,"");
            //buffer = data;
            //pc.printf("%s   , %s ,   %s\r\n",y,data_num,data);
        }
    }
    bool sleep(int mode) {
        Seri->printf("AT+SLEEP=%d",mode);
        return check();
    }
    bool deepsleep(int ms) {
        Seri->printf("AT+GSLP=%d",ms);
        return check();
    }
    bool httpAccess(char* mode,char* url,int port=80) {
        if(connected==false)return false;
        Seri->printf("AT+CIPSTART=\"%s\",\"%s\",%d",mode,url,port);
        return check();
    }    
    bool httpAccess(char id,char* url,char* mode = "TCP",int port=80) {
        if(connected==false)return false;
        Seri->printf("AT+CIPSTART=\"%d\",\"%s\",\"%s\",%d",id,mode,url,port);
        return check();
    }
    bool Disconnection(int id = 0)
    {
        printf("AT+CIPCLOSE==%d",id);
        return check();
    }
    void prompt() {
        Seri->attach(this,&esp8266::Reception);
    }
    //Seri->printf("AT+CIPSTA_CUR=\"%s\",\"%s\",\"%s\"",IP,gateway,netmask);
    bool setDHCP(int mode,int en) {
        DHCPMode = mode;
        DHCPenable = en;
        printf("AT+CWDHCP_CUR=%d,%d",mode,en);
        return check();
    }
    bool send( int num,char* data,int id) {
        if(connected==false)return false;
        Seri->printf("AT+CIPSEND=%d,%d",id,num+2);
        check();
        wait(0.01);
        while(1) {
            char i = Seri->getc();
            if(i=='>')break;
        }
        Seri->printf("%s",data);
        Seri->printf("\r\n");
        return check();
    }

    bool multipull(int i) {
        Seri->printf("AT+CIPMUX=%d",i);
        return check();
    }
    void reset() {
        Seri->printf("AT+RST\r\n");
        strChack("ready");
        wait(0.1);
    }
    void serverCreate(int mode,int port) {
        Seri->printf("AT+CIPSERVER=%d,%d",mode,port);
        check();
        wait(0.1);
        /*printf("\r\nwait connection\r\n");
        while(1) {
            char x[10];
            Seri->scanf("%s",x);
            if(strcmp(x,"0,CONNECT")==0)break;
        }*/
        //printf("\r\OK\r\n");
    }
    void serverTimeOutSet(int time = 60)
    {
        Seri->printf("AT+CIPSTO=%d",time);
        check(); 
    }
    
    bool accesspoint() {
        Seri->printf("AT+CWLAP\r\n");
        return check();
    }

    bool wifiSoftAPSetting(const char* ssid,const char* password,int ch,int ecn) {
        if(connectmode==AP||connectmode==APST)
            Seri->printf("AT+CWSAP_CUR=\"%s\",\"%s\",%d,%d",ssid,password,ch,ecn);
        else false;
        return check();
    }
    bool wifiConnectionMode(int mode) {
        connectmode=mode;
        Seri->printf("AT+CWMODE_CUR=%d",mode);
        return check();
    }
    bool wifiDisconnect() {
        Seri->printf("AT+CWQAP");
        connected=false;
        return check();
    }
    bool WifiFindAccesspoint(const char *wifi) {
        Seri->printf("AT+CWLAP=\"%s\"");
        return check();
    }
    bool WifiFindAccesspoint() {
        Seri->printf("AT+CWLAP");
        return check();
    }
    bool wifiConnect(const char* ssid,const char* password) {
        Seri->printf("AT+CWJAP_CUR=\"%s\",\"%s\"",ssid,password);
        connected|=check();
        //if(connected==false)return false;
        //Seri->printf("AT+CIFSR");
        //check();
        return connected;
    }
    bool wifiSoftAPFromIP() {
        if(connectmode == ST) return false;
        Seri->printf("AT+CWLIF");
        return check();
    }
    bool setSTMACAddress(char addr[6])
    {
        Seri->printf("AT+CIPSTART_CUR=\"%2x:%2x:%2x:%2x:%2x:%2x\"",addr[0],addr[1],addr[2],addr[3],addr[4],addr[5]);
        return check();
    }
    bool setAPMACAddress(char addr[6])
    {
        Seri->printf("AT+CIPAPMAC_CUR=\"%2x:%2x:%2x:%2x:%2x:%2x\"",addr[0],addr[1],addr[2],addr[3],addr[4],addr[5]);
        return check();
    }    
    bool setSTIPAddress(char addr[4])
    {
        Seri->printf("AT+CIPSTA_CUR=\"%3d:%3d:%3d:%3d\"",addr[0],addr[1],addr[2],addr[3]);
        return check();
    }
    bool setAPIPAddress(char addr[4])
    {
        Seri->printf("AT+CIPAP_CUR=\"%3d:%3d:%3d:%3d\"",addr[0],addr[1],addr[2],addr[3]);
        return check();
    }
    
    
    
    bool ATcommand(const char* cmd) {
        char a[20] = "";
        strcat(a,"AT");
        strcat(a,cmd);
        Seri->printf(a);
        return check();
    }
    const char AP=2;
    const char ST=1;
    const char APST=3;
    char  connectmode;
    char DHCPMode;
    char DHCPenable;
    esp8266(){
        connected=false;
        
        DHCPMode = 0;
        DHCPenable = 1;
        //Seri = ser;
        //Seri->printf("AT\r\n");
        
        //strChack("OK");
        //reset();
        wait(0.5);
    }
    void setSerial(Serial *ser)
    {
        Seri = ser;
        
        //Seri->printf("AT\r\n");
        
        //strChack("OK");
    }
};