#include "mbed.h"

PwmOut mypwm(PWM_OUT);

DigitalOut myled(LED1);
//InterruptIn Propo(A5);

class propoRead
{
    public:

    float High , Sum;
    float Max,Min,Normal,outMax,outMin;
    propoRead(PinName Pin , Timer *T) : Inter(Pin)
    {
        t = T;
        Inter.rise(this,&propoRead::Rise);
        Inter.fall(this,&propoRead::Fall);
        t->start();
        propoCalibration();
        outMax = 1;
        outMin = -1;
    }
    void propoCalibration(float max = 1900,float min = 1100,int normal = 1500)
    {
        Max = max-normal;
        Min = min-normal;
        Normal = normal;
    }
    operator float()
    {
        float width = Max-Min;
        float outWidth = outMax - outMin;
        float ratio = outWidth / width;
        
        float ans = ratio * (High - Normal);// outMin;
        if(fabs((double)ans)<0.1)    ans=0;
        return ans;
    }
    private:
    
    Timer *t;
    float prevTime;
    float readTime()
    {
        float ans = t->read_us() - prevTime;
        prevTime = t->read_us();
        return ans;
    }
    void Fall()
    {
        High = readTime();
    }
    void Rise()
    {
        prevTime = t->read_us();
    }
    InterruptIn Inter;
};
int main() {
    Timer T;
    propoRead p1(A5,&T);
    /*
    mypwm.period_ms(10);
    mypwm.pulsewidth_ms(1);
    */
    //printf("pwm set to %.2f %%\n", mypwm.read() * 100);

    //t.start();
    while(1) {  
        printf("%f\r\n",(float)p1);
        //wait(1);
    }
}
