#include "mbed.h"
#include "Hb.h"
#include "QEI.h"
#include "rtos.h"


#define ROTATE_PER_REVOLUTIONS  48
QEI wheel1(PB_13,PC_4,NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);

Serial pc(SERIAL_TX, SERIAL_RX);
Serial Dev(D8,D2);

Hb   hb1(PA_15,PB_7,PC_13,PC_12),hb2(PB_0,PA_1,PA_4,PC_1),
     hb3(PC_9,PC_6,PC_8,PC_5),hb4(PA_11,PB_1,PB_12,PB_2);


DigitalOut myled(LED1);// ,test1(PB_7) ,test2(PA_15) ,test3(PC_13) ,test4(PC_12);
#define N 6
char DATE[N]; 
void GET(void const *argument)
{
      while(1)
      {
          if(Dev.readable())
          {
            //if(Dev.getc()==0xff)
            for(int i=0 ; i<2 ; i++ )
            {
                DATE[i]=Dev.getc();
                //Thread::wait(0.0001);
                printf("%4d  ",DATE[i]);
            }
            pc.printf("  OK \n");
        }
    }
}

void rotate(void const *argument)
{
    while(true)
    {
        if(DATE[3]>100)
            hb4.run(Front);
            
        else if(DATE[4]>100)
            hb4.run(Back);
            
        else hb4.run(Stop);
        
        Thread::wait(0.1);
    }
}
void run(int i);
void run_duty(int i);
int main() {
  //Dev.attach(&GET);
  Thread thread(GET);
  Thread thread2(rotate);
  int i = 1;
  pc.printf("Hello World !\n");
  run(1);
  run_duty(255);
  wait(2);
  //test1=test2=test3=test4=1;
  while(1) {       
      //myled = !myled;

       // Thread::wait(1000);
        myled = !myled;
        //pc.printf("X");
        }
}
void run_duty(int i)
{
    float t = 255/i;
    hb1.run_duty(t);
    hb2.run_duty(t);  
    hb3.run_duty(t);   
}
void run(int i)
{
    int T;
    if(i==1)T=Front;  //strate
    else if(i==2)T=Back ;  //back
    else if(i==3)T=Stop;
    else if(i==4)T=Free;
    hb1.run(T);
    hb2.run(T);  
    hb3.run(T);
}
 