#include "Hb.h"
#include "mbed.h"
 
Hb::Hb(PinName _pin_h1, PinName _pin_h2, PinName _pin_g1, PinName _pin_g2) : pin_h1(_pin_h1), pin_h2(_pin_h2), pin_g1(_pin_g1), pin_g2(_pin_g2) 
{
    run(Free);
}
 
void Hb::set(float du , int pe) {
    duty = du;
    period = pe;
    pin_h1.period_ms(period);
    pin_h2.period_ms(period);
}
void Hb::run_duty(float du)
{
    if(flag==Front)
        pin_h1 = du;
    if(flag==Back)
        pin_h2 = du;
} 
void Hb::run(int i)
{
    pin_h1 = 0;
    pin_h2 = 0;
    pin_g1 = 0;
    pin_g2 = 0;
    wait(0.01);
     if(i==Front)
     {
            pin_h1 = duty;
            pin_h2 = 0;
            pin_g1 = 1;
            pin_g2 = 0;
            flag = Front;
    }
    if(i==Stop)
    {
            pin_h2 = 1;
            pin_h1 = 1;
            pin_g1 = 0;
            pin_g2 = 0;
    }

    if(i==Free)
    {
            pin_h1 = 0;
            pin_h2 = 0;
            pin_g1 = 0;
            pin_g2 = 0;
    }
    if(i==Back)
    {
            pin_h2 = duty;
            pin_h1 = 0;
            pin_g2 = 1;
            pin_g1 = 0;
            flag = Back;
    }
}