#ifndef NUNCHUCK_H
#define NUNCHUCK_H


#include "mbed.h"

#define NUNCHUCK_ANALOGDATA 1  //1 : analog   0 : degital
#define NUNCHUCK_DEADZONE 0    //analog stick's deadzone
#define NUNCHUCK_ADDR    0xA4  // 0x52 << 1

#define PI 3.14159265358979

class Nunchuck : I2C
{
    public:

        Nunchuck(PinName SDA, PinName SCL);
        int8_t analogx();
        int8_t analogy();
        double analograd();
        double analogdeg();
        double analogrange();
        int accx();
        int accy();
        int accz ();
        bool buttonc();
        bool buttonz();
        bool init();
        void getdata();
        void offset_(){
            offsetX = 0;
            offsetY = 0;
            
            for(int i = 0 ; i< 15;i++){
                getdata();
                wait(0.01);
            }
            offset = false;
            wait(0.2);
            //for(int i = 0;i<20;i++){
                offsetX = (char)analogx();
                offsetY = (char)analogy();
                //2ごうき
                //x:252
                //y:9
                //1ごうき
                //x:0
                //y:7
            //}
            //printf("\n%d , %d \n",offsetX,offsetY);
            offset = true;
            //offsetX= offsetX/20;
            //offsetY= offsetY/20;
        }
    private:
        Timer timer;
        bool flag;
        char data[6];
        int offsetX;
        int offsetY;
        bool offset;
};

#endif