#ifndef MotorClass_H
#define MotorClass_H

#include "mbed.h"

#define MotorMode        0x04
#define MotorState        0x0e
#define Who_am_I          0x2
#define MotorPWML          0x0f
#define MotorPWMH          0x10
#define MoterRevolutionL   0x11
#define MoterRevolutionH   0x12
#define MoterPulseL 0x13
#define MoterPulseH 0x14
#define MoterSpeedL 0x15
#define MoterSpeedH 0x16
#define Automatic   0x0
#define MotorP 0x30
#define MotorI 0x31
#define MotorD 0x32
#define FinishAuto 0x00
#define TargetSpeedH 0x24
#define TargetSpeedL 0x23
#define TargetAngleH 0x22
#define TargetAngleL 0x21
#define PulsePerRev 0x18
#define PulsePerRev2 0x19
#define PulsePerRevolutionL 0x25
#define PulsePerRevolutionH 0x26
#define PulsePerSec 0x27
#define PulsePerSec2 0x28
#define PulsePerAngle 0x20
#define RotateMode  0x17
#define Randam      0x3b
#define ADDRESS     0x3a
#define Debug1H     0x70
#define Debug1L     0x71
#define Debug2H     0x72
#define Debug2L     0x73
#define Debug3H     0x74
#define Debug3L     0x75

#define Front 1
#define Back 2
#define Stop 3
#define Free 4

class MotorClass
{
    I2C& i2c;
    QEI& wheel;
    Ticker QeiInt;
    private:
    
        char QEIMode;
        int AngOrSpe;
        char addr;
        char Action;
        void attach()
        {    
            double i = 0;
            if(AngOrSpe == 0)
                i=wheel.getSumangle();
            if(AngOrSpe == 1)
                i=wheel.getRPM()*1000;
            char reg[2] = {PulsePerRev,PulsePerSec};
            char data[2]={((short)i>>8),((short)i&0xff)};
            OutputSomeData(reg[AngOrSpe],data,2);
        printf("motor speed or angle is %f \r\n",i);
        }
        bool OutputOneData(char reg, char data )
        {
            char DATA[2]={reg,1};
            bool N  = i2c.write(addr,DATA,2); 
                 N |= i2c.write(addr,&data,1);
            return N;
        }
        bool OutputSomeData(char reg, char *data ,int size )
        {
            char DATA[2] = {reg,size};    
            bool N = i2c.write(addr,DATA,2);
                 N|= i2c.write(addr,data,size);
            return N;
        }
        char InputOneData(char address){   
           char DATA[2] = {address,1};
           char output; 
            i2c.write( addr , DATA, 2);  //tell it what you want to read
            i2c.read( addr , &output, 1);    //tell it where to store the data
            return output; 
        }
        void InputSomeData(char address, char* output, int size) {
            char DATA[2] = {address,size};
            i2c.write( addr, DATA, 2);  //tell it where to read from
            i2c.read( addr , output, size);      //tell it where to store the data read
        }
        float PWM;
        short target;
    public: 
        void UseAddress(char ad);
        float interval;
        MotorClass(I2C& _i2c,QEI& _qei);
        char SetAddress(char ad);
        char GetAddress();
        bool SetRate(char rate);
        bool Motor_PWM(float pwm);
        bool Setup(char action);
        bool Motor(char state,float pwm);
        bool SetP(float p);
        bool SetI(float i);
        bool SetD(float d);
        bool SetPID(float *pid);
        bool SetTarget(short tar);
        void StartQEIPut();
        void StopQEIPut();
        void QEIAllSetup(short tar,float *pid);
        void GetDebugData(float *data,int mode);
        float operator++(int) {        // 後置きの場合ダミーの引数 int をつける。
            
            if(Action == 1)
            {
                PWM+=0.01;
                Motor_PWM(PWM);
                return PWM;
            }
            else 
            {
                target+=10;
                SetTarget(short(target)); 
                return (float)target;
            }
        }
        short operator--(int) {        // 後置きの場合ダミーの引数 int をつける。
            
            if(Action == 1)
            {
                PWM-=0.01;
                Motor_PWM(PWM);
                return PWM;
            }
            else 
            {
                target-=10;
                SetTarget(short(target)); 
                return (float)target;
            }
        }
        void operator=(float val)
        {    
            if(Action == 1)
            {
                if(val<0)Motor(Back ,val*-1);
                else if(val>0)Motor(Front,val);
                else Motor(Stop , val);
            }
            else 
            {
                SetTarget(short(val)); 
            }
        }
};
#endif