/**
 * Includes
 */
#include "Motor.h"
Motor::Motor(const Motor& m):
    mode(m.Pin[0],m.Pin[1]),PwmPin(m.Pin[2])
{
    bias=0.0;
    max=m.max;
    //this
    PwmPin.period_ms(20);
    run(Stop,1);
}

Motor::Motor(PinName _pin1, PinName _pin2,PinName _pwm) :
    mode(_pin1,_pin2),PwmPin(_pwm)
{
    Pin[0] = _pin1;
    Pin[1] = _pin2;
    Pin[2] = _pwm;
    max=1.0;
    //this
    PwmPin.period_ms(10);
    run(Stop,1);
}
void Motor::run(int i,float duty)
{
    //static int state;
    Duty = (float)duty*max+bias;
    //printf("Duty %f \n",(float)duty);
    //if(state==i)return;
    PwmPin = Duty;
    if(state==i)return;
    mode=0;
    wait_us(20);
    if(i==Free) mode=0x00;
    else if(i==Back) mode=0x01|0x00;
    else if(i==Front) mode=0x00|0x02;
    else if(i==Stop) mode=0x01|0x02;
    else mode=0x00;
    state=i;
}




