
#ifndef Motor_H
#define Motor_H

#include "mbed.h"
#define Front 1
#define Back 2
#define Stop 3
#define Free 4
class Motor {
protected : PinName Pin[3];
    float bias;
    Motor(const Motor& m);
    Motor& operator=(const Motor &m) {
        return *this;
    }
public:

    Motor(PinName _pin1, PinName _pin2,PinName _pwm);

   
    Motor& operator= (float duty)
    {
        if(duty<-0.01F)
        {
            duty*=-1;
            run(Back,duty);
        }
        else if(float(duty)>0.01F)
        {
            run(Front,duty);
        }
        else run(Stop,0);
        return *this;
    }
    void run(int i,float duty);
    float min,max;
    void setbias_motor(float b){bias=b;}
    void duty_max(float Max){max=Max;}
    void duty_min(float Min){min=Min;}
    float getduty()
    {
        float a = PwmPin.read();
        return a;
    }
private:
    int state;
    float Duty;
    BusOut mode;
    PwmOut PwmPin;
};

#endif /* PID_H */
