#include "mbed.h"
#include "QEI.h"
#define SERIAL_BAUD 115200 

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
Serial pc(USBTX,USBRX);

int counts;
int counts2;
float potr = 0;
float potr2;
float tspeed = 0.01;
int desiredcount = 0;
int angleerror = 500;
int temp= 0;


QEI Encoder(D12,D13,NC,32);
DigitalOut motor2_direction(D7);
PwmOut motor2_speed(D6);
DigitalIn button1(PTA4);
DigitalIn button2(PTC6);
DigitalIn but1(D8);
AnalogIn pot1(A1);
AnalogIn pot2(A0);


void move(int angle){
     desiredcount = int(angle*11.65);
     if(counts < desiredcount - angleerror){
        motor2_direction = false;   
        if(counts > desiredcount- (10*angleerror) && counts < desiredcount - angleerror){
            motor2_speed = 0.15;
            } else {
        motor2_speed = tspeed;
        }
        
        }
    else if (counts > desiredcount + angleerror){
        motor2_direction = true;  
        if(counts < desiredcount + (10*angleerror) && counts > desiredcount +angleerror){
            motor2_speed = 0.15;
            }else {
        motor2_speed = tspeed;
        }
         
        }            
    else {
        motor2_speed = 0;
        }
    }
    


int main()
{
            pc.baud(SERIAL_BAUD);
            motor2_speed.period(1/500);

while (true){
    potr2 = pot1.read();
    counts = Encoder.getPulses();
    
    if(potr != potr2){
        potr = potr2;   
        tspeed = potr;    
        pc.printf("speed = %f \r\n", tspeed);
        } 
    

    if(button1==0 && button2 !=0){  //button 1
            move(0);
                  
    }       
    if(button2==0 && button1!=0){    //button2
        move(7200)  ;      
    }   
    if(button2==0 && button1==0){   //allebij
        move(2160);
        }
        
    if(button1!=0 && button2!=0) { // knopjes
        temp = int(360*pot2.read());
        move(temp);
        
    }
    if(but1==0){
        Encoder.reset();
        motor2_speed = 0;
        }
    if(counts!= counts2){
        counts2=counts;
        
    }
}
}