//   THis program contains 3 different parts, to control a servo motor, interface a PIR motion sensor and an Ultrasonic sensor
//   with the NXP FRDM-k64f board.
//   The program uses 3 libraries, one for the mbed functions, one for the Servo motor and one for the ultrasonic sensor.
//   The motion sensor sends out digital signals which are used as inputs to trigger interrupts.


//   Including libraries
#include "mbed.h"
#include "Servo.h"
#include "HCSR04.h"


//   Create a serial connection to pc through the mbed USB cable
Serial pc(USBTX,USBRX);     


//   Initializing instances of HCSR04, servo and interrupt pin
HCSR04 sensor(D8,D9);        //D8 is PTC12 and D9 is PTC4
Servo LRmyservo(PTC5);
InterruptIn motion(D2);      //D2 is PTB9



//   Initializing input at switch 2 and output at led 2
DigitalIn sw2(SW2);
DigitalOut Green(LED2);
 

//   Initializing global variables
int motion_detected = 0;



//   Defining IRQ routine
void irq_handler(void)
{
    motion_detected = 1;                                                       //raise flag if motion is detected
}


//   Function to rotate the servo, swaping direction of rotation based on position
void rotateServo(bool rotate)
{
   int i = 0;
   if (rotate == true)                                                         //rotate right
   { 
       for(i=10; i<111; i++)
       {
           LRmyservo = i/100.00;
           //pc.printf("read = %f\r\n", LRmyservo);
           wait_ms(4);
           if(motion_detected)
           {
               break;                                                          //Makes sure the servo doesnt drop another pill if one is already dropped
           }
       }
   } else                                                                      //rotate left
     { 
       for(i=110; i>=10; i--)
       {
           LRmyservo = i/100.00;
           //pc.printf("read = %d, signal = %d\r\n", LRmyservo.read(),something);
           wait_ms(4);
           if(motion_detected)
           {
               break;                                                          //Makes sure the servo doesnt drop another pill if one is already dropped
           }
       }
     }
}


//   Function to rotate the servo when switch is pressed
void servo_fnc()
{
    bool flag = false;
    bool rotate = true;
    
    while(flag == false)
    {
            if (sw2 == 0)
            {
                rotateServo(rotate);
                if (rotate == true)                                            //adjust rotation direction for next iteration
                { 
                    rotate = false;
                } else
                {
                    rotate = true;
                }
            }
    }
}


//   Function to detect motion on the tray, if pills are dispensed
void ultrasonic_fn()
{
    wait_ms(4000);
    int echoVal = sensor.echo_duration();
    Green = 1;
    
    while(1)
    {
        int a = sensor.echo_duration();
        if (a - echoVal > 75 || echoVal - a > 75)                              //blinks green led as long as the hand is detected over the tray
        {
            Green=0;
            wait(.2);
            Green=1;
            wait(.2);
        }
        pc.printf("%d \n\r",a);
        wait_ms(50);
    }
}


//   Function to detect motion of pill passing through the channel
void motion_sensor_fn()
{
    int cnt = 0;
    motion.fall(&irq_handler);
    Green=1;
    
    while(1) 
    {
        if(motion_detected) 
        {
            cnt++;
            motion_detected = 0;
            pc.printf("Hello! I've detected %d times since reset\r\n", cnt);
            Green=0;                                                           //blinks led 2 green once when pill is detected
            wait(.2);
            Green=1;
            wait(1);
        } else
        {
            pc.printf("did not detect\r\n");
        }
    }
}




//   Main program, runs one peripheral at a time since we were unable to run them concurrently
//   3 function calls define the respective routines, 2 are commented at a time to test the one
int main() 
{
    servo_fnc();
    //ultrasonic_fn()
    //motion_sensor_fn()
}   