/////////Automated Pill Dispenser/////////////
#include "mbed.h"
#include "M2XStreamClient.h"
#include "EthernetInterface.h"
#include "MFRC522.h"
#include "Servo.h"

#define SPI_SCLK    D13
#define SPI_MISO    D12
#define SPI_MOSI    D11 //pints for the RFID reader
#define SPI_CS      D10
#define MF_RESET    D9
 
MFRC522   RfChip(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET); //for the RFID chip
DigitalOut LedRed   (LED_RED); // LED Red
DigitalOut LedGreen (LED_GREEN); // LED green
DigitalOut LedBlue  (LED_BLUE); // LED blue

DigitalOut pin1(D4); //output pins for the stepper motor
DigitalOut pin2(D5);
DigitalOut pin3(D6);
DigitalOut pin4(D7);

AnalogIn LDRpin(A0); //analog output pin for the LDR

AnalogIn gp1(A2); //Pins for the weight sensor
AnalogIn gp2(A3);

Serial pc(USBTX, USBRX);
Servo LRmyservo(PTC5);

// Set Sensor Stream details
char deviceId[] = "8b23ea86abb3aa26711d4d6b92cbfe12"; // Device you want to push to
char streamLdr[] = "ldr_data"; // Stream you want to push to
char streamLoad[] = "load_data"; // Stream you want to push to
char m2xKey[] = "e952c10fdf5d62986f9e229564c92c83"; // Your M2X API Key or Master API Key

//Sequence for the stepper motor
int stepSequence[8][4] = 
{
  {0,0,0,1},
  {0,0,1,1},
  {0,0,1,0},
  {0,1,1,0},
  {0,1,0,0},
  {1,1,0,0},
  {1,0,0,0},
  {1,0,0,1},
};

int main(){
    wait_ms(3000);
    //turn all LEDs off
    LedRed   = 1;
    LedGreen = 1;
    LedBlue = 1;
    
    // Intialize Ethernet connection
    EthernetInterface eth;
    eth.init();
    eth.connect();
    printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());
    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
    int ret;
   
    //float ldr_time[3];
    float ldr_data=0.0;
    //float load_time[3];  
    float load_data=0.0;
    
    RfChip.PCD_Init(); // initialize RDID chip
    
    while (LedRed == 1) {  
        //code for stepper motor
        int count_third = 0;
        for(int j = 0; j <= 512; j++){
            if (count_third%3 == 0){  // rotate a third of a whole revolution
                for (int i = 0; i < 8; i++){
                    pin1 = stepSequence[i][0];
                    pin2 = stepSequence[i][1];
                    pin3 = stepSequence[i][2];
                    pin4 = stepSequence[i][3];
                    wait_ms(2);
               }
            }
            count_third++;
        }
        LedRed   = 1;
        LedGreen = 1;
        LedBlue = 1;
        wait_ms(500);
        
        //code for RFID reader
        for ( int k = 0; k < 40; k++){
            if ( ! RfChip.PICC_IsNewCardPresent()){
                wait_ms(50);
                continue;
            }
            LedRed   = 0;

            // Select one of the cards
            if ( ! RfChip.PICC_ReadCardSerial()){
                wait_ms(50);
                continue;
            }
            // Print Card type
            uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
            wait_ms(100);
        }
    }
    /////Servo Time!!!!!!/////
    float range = .0009;
    LRmyservo.calibrate(range,45);
    bool stop_Servo = false;
    bool pill_Detected = false;
    while (stop_Servo == false) {
        LRmyservo = 1.45;
        wait_ms(400);
        LRmyservo = 0.45;
        wait_ms(4000);
        
        for (int m = 0; m < 20; m++){
            float x = LDRpin * 1000;
            if (x < 140){
                pill_Detected = true;
            }
        }
        float x = LDRpin * 1000;
        if (pill_Detected == true && x > 200){
            LedBlue = 0;
            wait_ms(500);
            stop_Servo = true;
            ldr_data = 111;
        }
    }
    ret = m2xClient.updateStreamValue(deviceId, streamLdr, ldr_data);
    printf("send() returned %d\r\n", ret);
    ldr_data = 0;
    ret = m2xClient.updateStreamValue(deviceId, streamLdr, ldr_data);
    printf("send() returned %d\r\n", ret);

    
    //Weight Sensor!!!!!!//
    //Calibrate Sensor
//    float sum = 0;
//    for (int i = 0; i< 1000; i ++){
//        wait_ms(50);
//        sum = (gp2) *10000 + sum;
//    }
    
    float ave = 6877.67;
//    float ave = sum/1000;
    printf("the average is : %0.5f \r\n", ave);
    bool stop_load = false;
    while (stop_load == false) {
        float weightOut1 = gp1*10000;
        float weightOut2 = gp2*10000;
        float difference = weightOut2-ave;
        wait_ms(1000);
        if (difference > 15){
            printf("I made it here");
            bool stop_load = true;
            break;
        }
    }
    LedRed   = 1;
    LedGreen = 0;
    LedBlue = 1;
         
    //mag.acquire_mag_data_uT(mag_data);
    load_data = 0;
    ret = m2xClient.updateStreamValue(deviceId, streamLoad, load_data);
    load_data = 222;
    ret = m2xClient.updateStreamValue(deviceId, streamLoad, load_data);
    load_data = 0;
    ret = m2xClient.updateStreamValue(deviceId, streamLoad, load_data);
}   