#include "mbed.h"


/***********************************************/
/*      Declaration des variables globales     */
/***********************************************/
//GSM module connected to pin 13 and 14
Serial GSM(p13,p14);
//PC UART's definition
Serial pc(USBTX,USBRX);
//Declaration d'un Ticker
Ticker t1, t2, t3, t4;
//Definition des LED
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
//Autres variables
#define BUFSIZE  200
volatile bool FlagRx = false; //Se met &#65533; 1 lors de la reception d'une r&#65533;ponse compl&#65533;te
volatile bool FlagSMS = false; //On le met a 1 lorsque on lit un SMS pour executer la fonction 3 fois
unsigned int etat = 0, taille = 0, k = 0; //utilis&#65533; dans l'automate de r&#65533;ception pour definir l'&#65533;tat
volatile unsigned char BufferRx[BUFSIZE];//Buffer de reception
volatile unsigned char BufSMS[BUFSIZE];//Buffer de reception
volatile unsigned char i = 0, c;

/**************************************************************/
/*      Fonction de reception de donnees par interruption     */
/**************************************************************/
void Receive(void)
{
    c = GSM.getc();
    //pc.putc(c);
    //myled2 = !myled2;
    if(FlagSMS == 0)
    {
    
    switch(c)
    {
        case 0x0D :
            if(etat == 0)//Debutde la  reception
            {
                etat = 1;
                //pc.printf("etat 1\r\n");
            }
            if(etat == 2)//Reception du 0x0D de la fin
            {
                etat = 3;
                //pc.printf("etat 3\r\n");
            }
            break;
        case 0x0A :
            if(etat == 1)//Toujours au debutde la  reception
            {
                etat = 2;
                //pc.printf("etat 2\r\n");
            }
            if(etat == 3)//Reception du 0x0A de la fin
            {
                etat = 0;
                //pc.printf("ret etat 0\r\n");
                taille = i;
                i = 0;
                FlagRx = 1;
            }
            break;
        default : 
            if((etat == 2) && !(c == 0x0D))//Debutde lecture de la  reponse
            {
                BufferRx[i] = c;
                //pc.printf("default\r\n");
                i++;
            }
    }
    }
    else
    {
        switch(c)
    {
        case 0x0D :
            if(etat == 0)//Debutde la  reception
            {
                etat = 1;
                //pc.printf("etat 1\r\n");
            }
            if(etat == 2)//Reception du 0x0D de la fin
            {
                etat = 3;
                //pc.printf("etat 3\r\n");
            }
            if(etat == 4)//Reception du 0x0D de la fin
            {
                etat = 5;
                //pc.printf("etat 5\r\n");
            }
            if(etat == 6)//Reception du 0x0D de la fin
            {
                etat = 7;
                //pc.printf("etat 3\r\n");
            }
            if(etat == 8)//Reception du 0x0D de la fin
            {
                etat = 9;
                //pc.printf("etat 3\r\n");
            }
            break;
        case 0x0A :
            if(etat == 1)//Toujours au debutde la  reception
            {
                etat = 2;
                //pc.printf("etat 2\r\n");
            }
            if(etat == 3)//Reception du 0x0A de la fin
            {
                etat = 4;
                //pc.printf("etat 4\r\n");
            }
            if(etat == 5)//Reception du 0x0D de la fin
            {
                etat = 6;
                //pc.printf("etat 6\r\n");
            }
            if(etat == 7)//Reception du 0x0D de la fin
            {
                etat = 8;
                //pc.printf("etat 8\r\n");
            }
            if(etat == 9)//Reception du 0x0A de la fin
            {
                etat = 0;
                //pc.printf("ret etat 0\r\n");
                FlagSMS=0;
                taille = i;
                i = 0;
                FlagRx = 1;
            }
            break;
        default : 
            if((etat == 4) && !(c == 0x0D))//Debutde lecture de la  reponse
            {
                BufferRx[i] = c;
                //pc.printf("default\r\n");
                i++;
            }
    }
    }
}

/****************************************************/
/*      Fonction d'envoi de test avec le ticker     */
/****************************************************/
void SendTest(void)
{
    //GSM.printf("AT+CNMI?");
    GSM.printf("AT+CNMI?");
    GSM.putc(0x0D);
    myled1 = !myled1;
}

/******************/
/*      Blink     */
/******************/
void Blink1(void)
{
    myled1 = !myled1;
}
void Blink2(void)
{
    myled2 = !myled2;
}
void Blink3(void)
{
    myled3 = !myled3;
}
void Blink4(void)
{
    myled4 = !myled4;
}

/********************************************/
/*      Signaled que la carte est pr�te     */
/********************************************/
void Ready(void)
{
    myled1 = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
    wait(2);
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
}

/********************************/
/*      Fonction de parsing     */
/********************************/
void Parse(unsigned int taille)
{
    unsigned int j = 0;
    //Test de reception d'un nouvel SMS
    if((BufferRx[1]=='C')&&(BufferRx[2]=='M')&&(BufferRx[3]=='T')&&(BufferRx[4]=='I'))
    {
        //Lecture de l'SMS recu 
        pc.printf("SMS :");
        FlagSMS = 1;
        etat = 0;
        GSM.printf("AT+CMGR=");
        for(j=12;j<taille;j++)
        {
            GSM.putc(BufferRx[j]);
            pc.putc(BufferRx[j]);
        }
        GSM.putc(0x0D);
        pc.printf("\r\n");
        while(FlagSMS){;}
        //Commande L1ON
        if((BufferRx[0]=='L')&&(BufferRx[1]=='1')&&(BufferRx[2]=='O')&&(BufferRx[3]=='N'))
        {
            myled1 = 1;
        }
        //Commande L1OF
        if((BufferRx[0]=='L')&&(BufferRx[1]=='1')&&(BufferRx[2]=='O')&&(BufferRx[3]=='F'))
        {
            myled1 = 0;
        }
        //Commande L2ON
        if((BufferRx[0]=='L')&&(BufferRx[1]=='2')&&(BufferRx[2]=='O')&&(BufferRx[3]=='N'))
        {
            myled2 = 1;
        }
        //Commande L2OF
        if((BufferRx[0]=='L')&&(BufferRx[1]=='2')&&(BufferRx[2]=='O')&&(BufferRx[3]=='F'))
        {
            myled2 = 0;
        }
        //Commande L3ON
        if((BufferRx[0]=='L')&&(BufferRx[1]=='3')&&(BufferRx[2]=='O')&&(BufferRx[3]=='N'))
        {
            myled3 = 1;
        }
        //Commande L3OF
        if((BufferRx[0]=='L')&&(BufferRx[1]=='3')&&(BufferRx[2]=='O')&&(BufferRx[3]=='F'))
        {
            myled3 = 0;
        }
        //Commande L4ON
        if((BufferRx[0]=='L')&&(BufferRx[1]=='4')&&(BufferRx[2]=='O')&&(BufferRx[3]=='N'))
        {
            myled4 = 1;
        }
        //Commande L4OF
        if((BufferRx[0]=='L')&&(BufferRx[1]=='4')&&(BufferRx[2]=='O')&&(BufferRx[3]=='F'))
        {
            myled4 = 0;
        }
        //Commande L1BO
        if((BufferRx[0]=='L')&&(BufferRx[1]=='1')&&(BufferRx[2]=='B')&&(BufferRx[3]=='O'))
        {
            t1.attach(&Blink1, 0.5);
        }
        //Commande L1BS
        if((BufferRx[0]=='L')&&(BufferRx[1]=='1')&&(BufferRx[2]=='B')&&(BufferRx[3]=='S'))
        {
            t1.detach();
            myled1 = 0;
        }
        //Commande L2BO
        if((BufferRx[0]=='L')&&(BufferRx[1]=='2')&&(BufferRx[2]=='B')&&(BufferRx[3]=='O'))
        {
            t2.attach(&Blink2, 0.5);
        }
        //Commande L2BS
        if((BufferRx[0]=='L')&&(BufferRx[1]=='2')&&(BufferRx[2]=='B')&&(BufferRx[3]=='S'))
        {
            t2.detach();
            myled2 = 0;
        }
        //Commande L3BO
        if((BufferRx[0]=='L')&&(BufferRx[1]=='3')&&(BufferRx[2]=='B')&&(BufferRx[3]=='O'))
        {
            t3.attach(&Blink3, 0.5);
        }
        //Commande L3BS
        if((BufferRx[0]=='L')&&(BufferRx[1]=='3')&&(BufferRx[2]=='B')&&(BufferRx[3]=='S'))
        {
            t3.detach();
            myled3 = 0;
        }
        //Commande L4BO
        if((BufferRx[0]=='L')&&(BufferRx[1]=='4')&&(BufferRx[2]=='B')&&(BufferRx[3]=='O'))
        {
            t4.attach(&Blink4, 0.5);
        }
        //Commande L4BS
        if((BufferRx[0]=='L')&&(BufferRx[1]=='4')&&(BufferRx[2]=='B')&&(BufferRx[3]=='S'))
        {
            t4.detach();
            myled4 = 0;
        } 
    }
}

/***************************/
/*      Initialisation     */
/***************************/
void Init(void)
{
    GSM.baud(115200);//GSM baudrate
    GSM.format(8,Serial::None,1); //Serial frame format
    
    GSM.printf("AT+CPIN=1234");//Entrer le code PIN
    GSM.putc(0x0D);//envoi du caractere \n
    pc.printf("Saisie code PIN...\r\n");
    wait(5);
    GSM.printf("AT+CNMI=1,1");//Configurer le mode de signalement des nouveaux SMS recus
    GSM.putc(0x0D);//envoi du caractere \n
//    myled4 = 1;
    pc.printf("Config de l'alerte SMS\r\n");
    wait(2);
    
    GSM.printf("AT+CMGF=1");//Configurer le module en mode text
    GSM.putc(0x0D);//envoi du caractere \n
//    myled1 = 1;
    pc.printf("Passage en mode ""TEXT""\r\n");
    wait(2);
    /*GSM.printf("AT+CMGS=06XXXXXXXX");//Initialisation de l'nvoi de l'SMS au moniteur
    GSM.putc(0x0D);
    myled2 =1;
    //pc.printf("num\r\n");
    wait(2);
    GSM.printf("MBEDOK");//Text du SMS
    GSM.putc(0x1A);//Ctrl+Z pour valider l'envoi
    wait(5);//Attente de 5s le temps que le SMS parte
    pc.printf("Envoi OK\r\n");
    myled3 = 1;*/   
    pc.printf("Fin de l'init...\r\n");
    //Vider le buffer de reception
    /*for (i=0; i<BUFSIZE; i++) {  // vider le buffer 
        BufferRx[i] = 0; 
    }*/
    etat = 0;
    i=0;//reinitialisation de i
    FlagSMS = 0;
    wait(5);
    GSM.attach(&Receive, GSM.RxIrq);//Definition d'une interruption sur la reception de caractere du GSM
    pc.printf("Ready...\r\n");
    etat = 0;
    Ready();
}

int main() 
{
    
    Init();   
    
    //Routine d'effacement d'SMS
    /*for(j=21;j>0;j--)
    {
        GSM.printf("AT+CMGD=%d",j);
        GSM.putc(0x0D);
        pc.printf("Effacement SMS N %d\r\n",j);
        
        wait(1);
    }*/
    
    while(1) 
    {
        if(FlagRx == 1)
        {
            FlagRx = 0;
            
            /*for(j=0;j<taille;j++)
            {
                pc.putc(BufferRx[j]);
            }*/
            //pc.printf("\r\n");
            if(FlagSMS == 0)
            {
                Parse(taille);
            }
        }
        
    }
}
