//Program d'émission/reception et traitement d'SMS
#include "mbed.h"

//DigitalOut myled(LED1);
//Module GSM connecté sur les pin 13 et 14
Serial GSM(p13,p14);
//Declaration de l'interface serie du PC
Serial pc(USBTX,USBRX);

//Flush serial buffer
void FlushGSM(void) { char char1 = 0; while (GSM.readable()) { char1 = GSM.getc(); } return; }

int main() {
    int CPIN = 1234;//Code PIN de la carte SIM
    char NumTel[] = "0600000000";
    unsigned char i = 0;
    unsigned char j = 0;
    unsigned char CtrlZ = 0x1A;
    bool Flag = false;
    char r[]=""; //Chaine de caractère pour récupérer les réponses du module GSM
    GSM.baud(115200);//Vitesse de com avec le module GSM à 11520 Bauds
    GSM.format(8,Serial::None,1); //Format de la trame serie
    
    //Envoi du code PIN de la puce
    GSM.printf("AT+CIND=%d",CPIN);
    
    while(!GSM.readable()){;}//Attente de la réponse du module
    //Récupération de la réponse
    while(GSM.readable())
    {
        r[i] = GSM.getc();
        i++;    
    }
    //Si le Code pin entré est correcte, la SIM répondra par un OK
    //Donc, il faut chercher la chaine OK dans la réponse
    for(j=i-1;j--;0)
    {
        if((r[i]=='K')||(r[i]=='O'))
        {
            pc.printf("Code PIN correct !!!\r\n");
        }
        else
        {       
            pc.printf("Erreur code PIN !!!\r\n");
            return 0;
        }
    }
    //Configuration des SMS en mode Text
    GSM.printf("AT+CMGF=1");
    FlushGSM();//vider le buffer de reception 
    
    //Envoi d'un SMS à l'autre système pour lui signaler que le programme tourne
    GSM.printf("AT+CMGS=%s",NumTel);
    //Récupération de la réponse et recherche du caractère ">"
    while(GSM.readable())
    {
        if(GSM.getc()=='>')
        {
            Flag = true;
        }
    }
    if(Flag==true)
    {
        //Ecriture de l'SMS
        GSM.printf("Essai !!!");
        //Validation de l'envoi avec le caractère Ctrl+Z
        GSM.printf("%c",CtrlZ);
        //Attente de la réponse suite à l'envoi
        while(!GSM.readable()){;}
        i=0;
        while(GSM.readable())//Récupération de la réponse dans r[]
        {
            r[i]=GSM.getc();
            i++;
        }
        
    }
    else
    {
        pc.printf("Terminal error !!!");
        return 0;
    }
    
    while(1) {
        
    }
}
