#include "mbed.h"

// Set Board Pins
DigitalIn columns[3] = { PB_6, PB_7, PD_0 };                            // DEFINE: Board Pins for columns
DigitalOut rows[4] = { PA_5, PA_1, PA_2, PA_3  };                       // DEFINE: Board Pins for rows
char numpad[] = "123456789*0#";                                         // DEFINE: Keypad values as an array


extern "C" int 
    add_asm(int a, int b),
    sub_asm(int a, int b),
    mul_asm(int a, int b),
    div_asm(int a, int b),
    vdiv_asm(int a, int b);


// External function to call arithmetic
int mathFunc(int n0, int n1, int mathfunc){
    int answer;                                                         // EMPTY VARIABLE: For switch functions to cast
    
    switch(mathfunc) {                                                  // SWITCH: Choose arithmetic operator
        case 1: {                                                       // CASE: Addition
            answer = add_asm(n0, n1);
            break;
            }
        case 2: {                                                       // CASE: Subtraction
            answer = sub_asm(n0, n1);
            break;
            }
        case 3: {                                                       // CASE: Multiplication
            answer = mul_asm(n0, n1);
            break;
            }
        case 4: {                                                       // CASE: Division
            answer = div_asm(n0, n1);
            break;
            }
    }
    
    return answer;                                                      // Output answer from chosen operator
}

int main() {

    // Initiate Program
    printf("\n\n\n\rARM Mbed Arithmetic calculator\n\r");                   // AESTHETIC:  Program Name
    printf("  by Kenneth Haynie\n\r");                                  // AESTHETIC:  Author Name

    // Set Columns
    columns[0].mode(PullUp);                                            // HW SET: Set column 0 to pullup mode
    columns[1].mode(PullUp);                                            // HW SET: Set column 1 to pullup mode
    columns[2].mode(PullUp);                                            // HW SET: Set column 2 to pullup mode

    // Required Variables
    char input[5] = "";                                                 // EMPTY VARIABLE: Array to hold stored values
    int inputIndex = 0;                                                 // START VARIABLE: Index for current input array position
    int n0 = 0;                                                         // START VARIABLE: First integer store
    int n1 = 0;                                                         // START VARIABLE: Second integer store
    int mathfunc = 0;                                                   // START VARIABLE: Int variables to hold stored integer
    int step = 0;                                                       // START VARIABLE: Int variable for determining switch case
    
    //Initial Prompt
    printf("\n\rUsing the keypad, enter your numbers, then press '#' to move to next step.\n\r");
    printf("Input first number:   ");
    fflush(stdout);
    
    while(1) {
        for (int i = 0; i < 4; i++) {                                   // FOR: Perform functions for every keypad row i
            
            // Set Rows
            rows[0] = 1;                                                // HW SET: Set row 0 to value of 1
            rows[1] = 1;                                                // HW SET: Set row 1 to value of 1
            rows[2] = 1;                                                // HW SET: Set row 2 to value of 1
            rows[3] = 1;                                                // HW SET: Set row 3 to value of 1
            rows[i] = 0;                                                // HW SET: Set row i to value of 0
            wait(0.01);                                                 // WAIT: Force hold row i at value 0 for 10 ms
            
            // Read Columns
            for (int j = 0; j < 3; j++) {                               // FOR:  Perform for each column 
                if (columns[j] == 0) {                                  // If this column has been pulled down to 0
                    // Read button
                    int pos = 3 * i + j;                                // Find position in numpad[]

                    if (pos == 9) {}                                    // IF: '*', do nothing
                    else if (pos == 11) {                               // IF: '#', ...
                        if (inputIndex == 0) {                          // IF: current input is empty
                            input[inputIndex] = '0';                    // WRITE: '0' to input
                            input[inputIndex+1] = '\0';                 // WRITE: Close array
                        }
                        switch(step) {                                  // SWITCH: Check for current step in program
                            case 0: {   n0 = atoi(input);               // CASE: For step = 0, convert and store input to n0
                                        step = 1;                         // INCREMENT: Advance to step 1
                                        printf("\n\rInput second number:  ");
                                        fflush(stdout);
                                        break;                          // CASE: End case 0
                                    }
                            case 1: {   n1 = atoi(input);               // CASE: For step = 1, convert and store input to n1
                                        printf("\n\rSelect an operand:\n\r"); // AESTHETIC: Operator Menu
                                        printf("  (1) +\n\r");        // AESTHETIC: Operator Menu
                                        printf("  (2) -\n\r");   // AESTHETIC: Operator Menu
                                        printf("  (3) *\n\r");   // AESTHETIC: Operator Menu
                                        printf("  (4) /\n\r");     // AESTHETIC: Operator Menu
                                        printf("Input option number:  ");
                                        fflush(stdout);
                                        step = 2;                         // INCREMENT: Advance to step 2
                                        break;                          // CASE: End case 1
                                    }
                            case 2: {   mathfunc = atoi(input);         // CASE: For step = 2, convert and store operator selection
                                        int x = mathFunc(n0, n1, mathfunc);  // FUNCTION: Send two numbers and operator for parsing
                                        printf("\n\rAnswer = %d\n\r", x);  // AESTHETIC: Output answer
                                        printf("\n\rInput first number:  ");
                                        fflush(stdout);
                                        step = 0;                       // RESET: Set step to 0
                                        n0 = 0;                         // RESET: Set first number to 0
                                        n1 = 0;                         // RESET: Set second number to 0
                                        break;                          // CASE: End case 2
                                    }                                        
                        }
                        input[0] = '\0';                                // RESET: Clear input
                        inputIndex = 0;                                 // RESET: Revert input index to 0
                    } else {                                            // IF: Any number value pressed on keypad
                        input[inputIndex] = numpad[pos];                // WRITE: Append current digit to input
                        input[inputIndex + 1] = '\0';                   // WRITE: Close array
                        inputIndex++;                                   // INCREMENT: Advance input index to next position
                        printf("%c", numpad[pos]);
                        fflush(stdout);
                    }

                    wait(0.005);                                        // WAIT: Force read column j for 5 ms
                    while (columns[j] == 0);                            // WAIT: Wait for current button to be released
                }
            }
        }
    }
}