#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"

C12832_LCD lcd;

// const char* SERVER_ADDRESS = "192.168.50.121";
const int SERVER_PORT      = 80;

const char* MY_ADDRESS     = "192.168.50.125";
const char* MY_MASK        = "255.255.255.0";
const char* MY_GATEWAY     = "192.168.50.254";

EthernetInterface eth;
Serial serial1(p9, p10); // tx, rx
DigitalOut myled(LED1);


 float a[1];


int main(void) {
    
    a[0]=5;
    
    // set IPAddress , Mask , Gateway
    eth.init(MY_ADDRESS,MY_MASK,MY_GATEWAY);
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(SERVER_PORT);
    server.listen();
    
    while (true) {
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        char str[6];
        char sendbuf[335];
        sprintf(sendbuf,  "HTTP/1.1 200 OK\r\n"
                          "Server: 192.168.50.79\r\n"
                          "Content-Length: 215\r\n"
                          "Content-Type: text/html\r\n"
                          "\r\n"
                          "<html>\r\n"
                            "<head>\r\n"
                                "<title>test</title>\r\n"
                                "<body>\r\n"
                                "<font size=\"7\"><center>Test of tiny server</font></center>\r\n"
                                "<center>temperature:%.2f[W]</center>\r\n"
                                "</body>\r\n"
                          "</html>\r\n"
                          , a[0]);

        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
        }
        
        printf("%s\n", buffer);
        strncpy(str, buffer+5, 4);
        str[4] = '\0';
        printf("%s\n", str);
        
    
        client.send_all(sendbuf, sizeof(sendbuf)- 1);
    }
}
