#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"

C12832_LCD lcd;

/* send int by queue */

Queue<int, 16> queue;

/* Send Thread */
void send_thread (void const *args) {
    int message_s = 0 ;
    while (true) {
        message_s++; 
        queue.put(&message_s);
        Thread::wait(1000);
    }
}

int main (void) {
    int *message_r;
    
    Thread thread(send_thread);
    
    while (true) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            message_r = (int*)evt.value.p;
            lcd.printf("%d ", *message_r);
        }
    }
}
