#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
Mutex lcd_mutex; 

void mu_write(const char* name) {
    Thread::wait(rand()/1000000);
    lcd_mutex.lock();
    lcd.locate(0,3);
    lcd.printf("%s writing\n\r", name);
    Thread::wait(1000);
    lcd.cls();
    lcd_mutex.unlock();
}

void test_thread(void const *args) {
    while (true) {
        mu_write((const char*)args); 
    }
}

int main() {
    lcd.cls();
    Thread t2(test_thread, (void *)"Th 2");
    Thread t3(test_thread, (void *)"Th 3");
    Thread t4(test_thread, (void *)"Th 4");
    
    test_thread((void *)"Th 1");
}
