#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"

C12832_LCD lcd;

/* Mail */
typedef struct {
  float    temp;
  float    humid; 
  float    illumi;
  // uint32_t  count; 
} mail_t;

Mail<mail_t, 16> mail_box;

void send_thread (void const *args) {
   uint32_t count= 0;
    while (true) {
        count++; // fake data update
        mail_t *mail = mail_box.alloc();
        mail->temp = ( count * 0.1) * 30; 
        mail->humid = (count * 0.1) * 50;
        mail->illumi = (count * 0.1) * 50;
       // mail->count = count;
        mail_box.put(mail);
        Thread::wait(1000);
    }
}

int main (void) {
    Thread thread(send_thread);
    
    while (true) {
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
            mail_t *mail = (mail_t*)evt.value.p;
            lcd.printf("temp: %.2f \n\r"   , mail->temp);
            lcd.printf("humid: %.2f \n\r"     , mail->humid);
            lcd.printf("illumination: %.2f \n\r"     , mail->illumi);
           // lcd.printf("Number of cycles: %u\n\r", mail->counter);
            
            mail_box.free(mail);
        }
    }
}
