#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
Mutex lcd_mutex; 

void lcd_thread1(void const *argument) {
    int count1;
    while (true) {
        Thread::signal_wait(0x1);
        lcd_mutex.lock();
        lcd.locate(0,3);
        lcd.printf("%thread2 count: %d\n\r", count1);
        lcd_mutex.unlock();
        count1++;
    }
}

void count_thread1(void const *argument){
    Thread thread2(lcd_thread1);
    while (true) {
        Thread::wait(1000);
        thread2.signal_set(0x1);
    }
}

void lcd_thread2(void const *argument) {
    int count2=0;
    while (true) {
        Thread::signal_wait(0x1);
        // lcd_mutex.lock();
        lcd.locate(0,15);
        lcd.printf("%thread4 count: %d\n\r", count2);
        // lcd_mutex.unlock();
        count2++;
    }
}

void count_thread2(void const *argument){
    Thread thread4(lcd_thread2);
    while (true) {
        Thread::wait(2000);
        thread4.signal_set(0x1);
    }
}

int main() {
    lcd.cls();
    Thread thread1(count_thread1);
//    Thread thread2(lcd_thread1);
    Thread thread3(count_thread2);
//    Thread thread4(lcd_thread2);
    Thread::wait(osWaitForever);    
}
