#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
 
 

/*
 * Use DHCP
 */
//        EthernetNetIf ethif;

/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
       EthernetNetIf ethif(IpAddr(192,168,50,125), 
                           IpAddr(255,255,255,0), 
                           IpAddr(192,168,50,254),
                           IpAddr(192,168,110,3));

    
    HTTPServer server;
    LocalFileSystem local("local");
 
int main(void) {
 
  
   // lcd.locate(0,3);
    lcd.printf("Program init..  ");
 
    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    IpAddr ethIp=ethif.getIp();
    
   
    wait(1.0);
    server.addHandler<SimpleHandler>("/hello");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    
    lcd.cls();
    lcd.locate(0,15);
    lcd.printf("%d.%d.%d.%d", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    
    while (1) {
        Net::poll();
    }
    return 0;

}
