#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "LM75B.h"

C12832_LCD lcd;

const char* SERVER_ADDRESS = "192.168.50.121";
const int SERVER_PORT      = 80;

const char* MY_ADDRESS     = "192.168.50.125";
const char* MY_MASK        = "255.255.255.0";
const char* MY_GATEWAY     = "192.168.50.254";

EthernetInterface eth;
DigitalOut myled1(LED1);
LM75B tmp(p28,p27);
Serial pc(USBTX, USBRX); // tx, rx
Serial dev_xbee(p9, p10);  // tx, rx        

int main(void) {
 float temp1 ;

    int pkt_phase=0;
    int pkt_count=0;
    char* ch[16]={"0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"};
    char v_val[2];
    int over_flag=0;
    TCPSocketConnection socket;
    char val;
    int v_val_int;
    int tmp1,tmp2, i, n;
    int sd_data_on[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0x92,0xFF,0x77,0xFF,0xFE,0x02,0x44,0x32,0x05,0x70};
    int sd_data_off[20]={0x7E,0x00,0x10,0x17,0x01,0x00,0x13,0xA2,0x00,0x40,0x92,0xFF,0x77,0xFF,0xFE,0x02,0x44,0x32,0x04,0x71};
    lcd.cls();
    
    eth.init(MY_ADDRESS,MY_MASK,MY_GATEWAY);
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    while(1){    
        myled1=1;
        val=dev_xbee.getc();
        pkt_count++;
        if(pkt_phase==0 && val==0x7E){
            pkt_phase=1;
            pkt_count=1;
        }
    
        if(pkt_phase==1 && pkt_count==4){
            if( val==0x92 ){
                pkt_phase=2;
            }else{
                pkt_count=0;
                pkt_phase=0;
            }
        }   
    
        if(pkt_phase==2 && pkt_count==12){
            if( val==0x77){
                pkt_phase=3;
            }else{
                pkt_count=0;
                pkt_phase=0;
            }
        }
  
    
        if(pkt_phase==3 && pkt_count==22){
            pkt_phase=4;
            v_val[0]=val;
        }
    
        if(pkt_phase==4 && pkt_count==23){
            pkt_phase=0;
            pkt_count=0;
            v_val[1]=val;

            v_val_int = (int)v_val[0]*256 + (int)v_val[1];
            if(v_val_int < 1000 ){
                for(i=0 ; i<20 ; i++){
                    dev_xbee.putc(sd_data_on[i]);
                }
            }
            if(v_val_int >= 1000 ){
                for(i=0 ; i<20 ; i++){
                    dev_xbee.putc(sd_data_off[i]);
                }
            }
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("v_val1:%d ",v_val_int);
            temp1=tmp.read();
            if (socket.connect(SERVER_ADDRESS, SERVER_PORT) < 0) {
                pc.printf("Unable to connect to (%s) on port (%d)\n", SERVER_ADDRESS, SERVER_PORT);
            }else {
                pc.printf("connection succeded");
                char buffer[900];
                sprintf(buffer,"POST /next7/REST/Record/HayaLab03 HTTP/1.1\r\n"
                    "Host: 192.168.50.121\r\n"
                    "Content-Type: application/xml\r\n"
                    "Content-Length: 690\r\n"
                    "\r\n" 
                    "<PostData xmlns:a=\"http://schemas.microsoft.com/2003/10/Serialization/Arrays\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n"
                    "<PassCode>A123</PassCode>\r\n"
                    "<StrDataKey />\r\n"
                    "<StrDataValue />\r\n"
                    "<NumDataKey>\r\n"
                    "<a:string>Temp1</a:string>\r\n"
                    "<a:string>lx1</a:string>\r\n"
                    "</NumDataKey>\r\n"
                    "<NumDataValue>\r\n"
                    "<a:decimal>%.2f</a:decimal>\r\n"
                    "<a:decimal>%d</a:decimal>\r\n"
                    "</NumDataValue>\r\n"
                    "<DatetimeDataKey />\r\n"
                    "<DatetimeDataValue />\r\n"
                    "<ExNumDataKey />\r\n"
                    "<ExNumDataValue />\r\n"
                    "</PostData>\r\n"
                ,temp1, v_val_int);
            // Send xml to Server 
                socket.send_all(buffer,sizeof(buffer) - 1);
            
            // receive reply
                n=0;
                char buf[400];
                n = socket.receive(buf, 400);
                buf[n] = '\0';
                // printf("%d %s",n, buf);  
                lcd.locate(0,15);
                lcd.printf("temperature=%.2f\n",temp1);        
            }
            socket.close();
            //   Thread::wait(60000);
    

        }
    
    
    tmp1 = val/16;
    tmp2 = val%16;
    pc.printf("%s%s",ch[tmp1],ch[tmp2]);
    myled1=0;
    
    }


}
