#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "LM75B.h"

C12832_LCD lcd;

const char* SERVER_ADDRESS = "192.168.50.121";
const int SERVER_PORT      = 80;

const char* MY_ADDRESS     = "192.168.196.94";
const char* MY_MASK        = "255.255.255.0";
const char* MY_GATEWAY     = "192.168.196.254";

EthernetInterface eth;

DigitalOut myled(LED1);
LM75B tmp(p28,p27);

 float a[0] ;

int main(void) {
    // set IPAddress , Mask , Gateway
    eth.init(MY_ADDRESS,MY_MASK,MY_GATEWAY);
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection socket;
    
    int n;
    
    while (1) 
    {
        a[0]=tmp.read();
        if (socket.connect(SERVER_ADDRESS, SERVER_PORT) < 0) {
            printf("Unable to connect to (%s) on port (%d)\n", SERVER_ADDRESS, SERVER_PORT);
        }else {
            printf("connection succeded");
            char buffer[900];
            sprintf(buffer,"POST /next7/REST/Record/HayaLab03 HTTP/1.1\r\n"
                "Host: 192.168.50.121\r\n"
                "Content-Type: application/xml\r\n"
                "Content-Length: 690\r\n"
                "\r\n" 
                "<PostData xmlns:a=\"http://schemas.microsoft.com/2003/10/Serialization/Arrays\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n"
                "<PassCode>A123</PassCode>\r\n"
                "<StrDataKey />\r\n"
                "<StrDataValue />\r\n"
                "<NumDataKey>\r\n"
                "<a:string>Temp1</a:string>\r\n"
                "</NumDataKey>\r\n"
                "<NumDataValue>\r\n"
                "<a:decimal>%.2f</a:decimal>\r\n"
                "</NumDataValue>\r\n"
                "<DatetimeDataKey />\r\n"
                "<DatetimeDataValue />\r\n"
                "<ExNumDataKey />\r\n"
                "<ExNumDataValue />\r\n"
                "</PostData>\r\n"
            ,a[0]);
            // Send xml to Server 
            socket.send_all(buffer,sizeof(buffer) - 1);
            
            // receive reply
            n=0;
            char buf[400];
            n = socket.receive(buf, 400);
            buf[n] = '\0';
            printf("%d %s",n, buf);  
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("temperature=%.2f\n",a[0]);        
        }
        socket.close();
        Thread::wait(60000);
    }

}
