#include "mbed.h"

#define get_event
#define ev
#define green   1
#define red     0
#define off     0
#define on      1
#define flashing    2

enum state {st_GND_DC,st_GND_DO,st_GND_closing,st_DSING_at1,st_GU_closing,st_GND_opening,st_Top_DC,st_Top_DO,st_waiting_for_GND,st_waiting_for_Top,st_DC_moving_up,st_DC_moving_dwn,};
enum event {ev_no_event,ev_Top,ev_GND,ev_near_top,ev_near_GND,ev_swt_up,ev_swt_dwn,ev_LVL1_swt,ev_LVL2_swt,ev_mtr_finish,ev_time_out};

int green_flashing, red_flashing;

DigitalOut green_led(LED1);
DigitalOut red_led(LED4);
Ticker led_flasher;
Ticker timer;

void led(int colour, int mode) {
    switch (colour) {
        case green:
            switch (mode) {
                case off:
                    green_led = off;
                    green_flashing = off;
                    break;
                case on:
                    green_led = on;
                    green_flashing = off;
                    break;
                case flashing:
                    green_led = on;
                    green_flashing = on;
                    break;
            }
            switch (colour) {
                case red:
                    switch (mode) {
                        case off:
                            red_led = off;
                            red_flashing = off;
                            break;
                        case on:
                            red_led = on;
                            red_flashing = off;
                            break;
                        case flashing:
                            red_led = on;
                            red_flashing = on;
                            break;
                    }
            }

    }

    void new_event(int ev) {
        event_queue[ev_load] = ev;
        ev_load++;
        if (ev_load == 8)
            ev_load = 0;
    }

    int get_event(void) {
        int ev;
        if (ev_load != ev_unload) {
            ev = event_queue[ev_unload];
            ev_unload++;
            if (ev_unload ==8)
                ev_unload = 0;
        } else ev = no_event;
        return ev;
    }

    void flash(void) {
        if (green_flashing)
            green_led = !green_led;
        if (red_flashing)
            red_led = !red_led;
    }

    void update_timeout(void) {
        if (time_out) {
            time_out --;
            if (time_out==0)
                new_event(ev_time_out);
        }
    }






    int main() {

        int state;
        led_flasher.attach(&flash,0.15);
        timer.attach(&update_timeout,0.1);
        switch (state) {
            case st_GND_DC:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case ev_swt_up:
                            led(green,flashing);
                            led(red,off);
                            time_out = 20;
                            state = st_GND_opening;
                            break;
                        case ev_swt_dwn:
                            motor(up,1.0,20);
                            state = st_DC_moving_up;
                            break;
                    }
                }
                break;
            case st_GND_DO:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case  ev_time_out:
                            led(green,off);
                            led(red,flashing);
                            time_out = 20;
                            state = st_GND_closing;
                            break;
                        case ev_LVL2_swt:
                            led(red,flashing);
                            led(green,off);
                            time_out = 20;
                            state = st_GU_closing;
                            break;

                    }
                }
                break;
            case st_GND_closing:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case  ev_time_out:
                            led(red,on);
                            state = st_GND_DC;
                            break;
                    }
                }
                break;
            case st_GND_opening:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case  ev_time_out:
                            led(green,on);
                            time_out = 20;
                            state = st_GND_DC;
                            break;
                    }
                }
                break;
            case st_Top_DC:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case  st_Top_DC:
                            led(red, of);
                            time_out = 20;
                            state = st_GND_DC;
                            break;
                    }
                }
                break;
            case st_Top_DO:
                ev = get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case ev_time_out:
                            time_out = 50;
                            led(green, off);
                            led(red,flashing);
                            state= st_DSING_at1,
                            break;

                    }

                }
                break;
            case st_DSING_at1:
                ev = get_event();
                if (ev!=no_event)
                    switch (ev) {
                        case ev_time_out:
                            time_out= 20;
                            led(red, off);
                            state = st_Top_DC;
                            break;
                    }
                break;
            case st_waiting_for_GND:

                break;
            case st_waiting_for_Top:
                ev= get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case ev_Top:
                            motor(up,0.0,0.0);
                            led(green,flashing);
                            led(red, off);
                            state= st_Top_DO;
                            break;

                    }
                }

                break;
            case st_DC_moving_up:
                ev= get_event();
                if (ev!=no_event) {
                    switch (ev) {
                        case ev_near_top:
                            motor(up,1.0,1.0);
                            state= st_waiting_for_Top;
                            break;
                    }
                }

                break;
            case DC_moving_dwn:
                ev= get_event();
                if (ev!=no_event) {
                    switch {
                    case ev_near_GND:
                    motor(dwn,0.1,2);
                    state= st_waiting_for_GND;
                    break;
                        }
            }
            break;


    }
}